/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.chain;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.mule.runtime.core.util.NotificationUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ModuleOperationMessageProcessorChainBuilder
extends ExplicitMessageProcessorChainBuilder {
    private static final String PARAM_VARS = "param";
    private static final String PROPERTY_VARS = "property";
    private Map<String, String> properties;
    private Map<String, String> parameters;
    private boolean returnsVoid;
    private ExpressionManager expressionManager;

    public ModuleOperationMessageProcessorChainBuilder(Map<String, String> properties, Map<String, String> parameters, boolean returnsVoid, ExpressionManager expressionManager) {
        this.properties = properties;
        this.parameters = parameters;
        this.returnsVoid = returnsVoid;
        this.expressionManager = expressionManager;
    }

    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new ModuleOperationProcessorChain("wrapping-operation-module-chain", head, processors, processorForLifecycle, this.properties, this.parameters, this.returnsVoid, this.expressionManager);
    }

    static class ModuleOperationProcessorChain
    extends ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain
    implements Processor,
    MessageProcessorContainer {
        private Map<String, String> properties;
        private Map<String, String> parameters;
        private boolean returnsVoid;
        private ExpressionManager expressionManager;

        ModuleOperationProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle, Map<String, String> properties, Map<String, String> parameters, boolean returnsVoid, ExpressionManager expressionManager) {
            super(name, head, processors, processorsForLifecycle);
            this.properties = properties;
            this.parameters = parameters;
            this.returnsVoid = returnsVoid;
            this.expressionManager = expressionManager;
        }

        @Override
        public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
            MessageProcessorPathElement subprocessors = pathElement.addChild(this.name).addChild("subprocessorsModuleOperations");
            NotificationUtils.addMessageProcessorPathElements(this.processors, subprocessors);
        }

        @Override
        protected Event doProcess(Event event) throws MuleException {
            Event eventResponse = super.doProcess(this.createEventWithParameters(event));
            if (!this.returnsVoid) {
                event = this.createNewEventFromJustMessage(event, eventResponse);
            }
            return event;
        }

        @Override
        public Publisher<Event> apply(Publisher<Event> publisher) {
            if (!this.returnsVoid) {
                return Flux.from(publisher).concatMap(request -> Flux.just((Object)request).map(event -> this.createEventWithParameters((Event)event)).transform(s -> super.apply((Publisher<Event>)s)).map(result -> this.createNewEventFromJustMessage((Event)request, (Event)result)));
            }
            return publisher;
        }

        private Event createNewEventFromJustMessage(Event request, Event response) {
            return Event.builder(request).message(InternalMessage.builder(response.getMessage()).build()).build();
        }

        private Event createEventWithParameters(Event event) {
            Event.Builder builder = Event.builder(event.getContext());
            builder.message(InternalMessage.builder().nullPayload().build());
            builder.addVariable(ModuleOperationMessageProcessorChainBuilder.PARAM_VARS, this.evaluateParameters(event, this.parameters));
            builder.addVariable(ModuleOperationMessageProcessorChainBuilder.PROPERTY_VARS, this.evaluateParameters(event, this.properties));
            return builder.build();
        }

        private Map<String, Object> evaluateParameters(Event event, Map<String, String> unevaluatedMap) {
            return unevaluatedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getEvaluatedValue(event, (String)entry.getValue())));
        }

        private Object getEvaluatedValue(Event event, String value) {
            return this.expressionManager.isExpression(value) ? this.expressionManager.evaluate(value, event, this.flowConstruct) : value;
        }
    }
}

