/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.CompositeOperationPolicy;
import org.mule.runtime.core.policy.CompositeSourcePolicy;
import org.mule.runtime.core.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.policy.FailureSourcePolicyResult;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.NullPolicyProvider;
import org.mule.runtime.core.policy.OperationExecutionFunction;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.core.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.PolicyPointcutParameters;
import org.mule.runtime.core.policy.PolicyProvider;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SourcePolicyPointcutParametersFactory;
import org.mule.runtime.core.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyStateHandler policyStateHandler;
    private Collection<OperationPolicyParametersTransformer> operationPolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyParametersTransformer> sourcePolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories = Collections.emptyList();
    private Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories = Collections.emptyList();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;

    @Override
    public SourcePolicy createSourcePolicyInstance(ComponentIdentifier sourceIdentifier, Event sourceEvent, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        PolicyPointcutParameters sourcePointcutParameters = this.createSourcePointcutParameters(sourceIdentifier, sourceEvent);
        List<Policy> parameterizedPolicies = this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return event -> {
                try {
                    Event flowExecutionResult = flowExecutionProcessor.process(sourceEvent);
                    if (flowExecutionResult == null) {
                        flowExecutionResult = Event.builder(sourceEvent).message((InternalMessage)Message.builder().nullPayload().build()).build();
                    }
                    return Either.right(new SuccessSourcePolicyResult(flowExecutionResult, messageSourceResponseParametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply(flowExecutionResult), messageSourceResponseParametersProcessor));
                }
                catch (Exception e) {
                    MessagingException messagingException = e instanceof MessagingException ? (MessagingException)((Object)((Object)e)) : new MessagingException(event, e, flowExecutionProcessor);
                    return Either.left(new FailureSourcePolicyResult(messagingException, messageSourceResponseParametersProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent())));
                }
            };
        }
        return new CompositeSourcePolicy(parameterizedPolicies, this.lookupSourceParametersTransformer(sourceIdentifier), this.sourcePolicyProcessorFactory, flowExecutionProcessor, messageSourceResponseParametersProcessor);
    }

    @Override
    public OperationPolicy createOperationPolicy(ComponentIdentifier operationIdentifier, Event event, Map<String, Object> operationParameters, OperationExecutionFunction operationExecutionFunction) {
        PolicyPointcutParameters operationPointcutParameters = this.createOperationPointcutParameters(operationIdentifier, operationParameters, event.getContext().getOriginatingFlowName());
        List<Policy> parameterizedPolicies = this.policyProvider.findOperationParameterizedPolicies(operationPointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return operationEvent -> operationExecutionFunction.execute(operationParameters, operationEvent);
        }
        return new CompositeOperationPolicy(parameterizedPolicies, this.lookupOperationParametersTransformer(operationIdentifier), this.operationPolicyProcessorFactory, () -> operationParameters, operationExecutionFunction);
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.operationPolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.sourcePolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    public void initialise() throws InitialisationException {
        try {
            this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory(this.policyStateHandler);
            this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory(this.policyStateHandler);
            this.policyProvider = this.muleContext.getRegistry().lookupObject(PolicyProvider.class);
            if (this.policyProvider == null) {
                this.policyProvider = new NullPolicyProvider();
            }
            this.sourcePolicyParametersTransformerCollection = this.muleContext.getRegistry().lookupObjects(SourcePolicyParametersTransformer.class);
            this.operationPolicyParametersTransformerCollection = this.muleContext.getRegistry().lookupObjects(OperationPolicyParametersTransformer.class);
            this.sourcePointcutFactories = this.muleContext.getRegistry().lookupObjects(SourcePolicyPointcutParametersFactory.class);
            this.operationPointcutFactories = this.muleContext.getRegistry().lookupObjects(OperationPolicyPointcutParametersFactory.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
        }
    }

    private PolicyPointcutParameters createSourcePointcutParameters(ComponentIdentifier sourceIdentifier, Event sourceEvent) {
        return this.createPointcutParameters(sourceIdentifier, sourceEvent.getContext().getOriginatingFlowName(), SourcePolicyPointcutParametersFactory.class, this.sourcePointcutFactories, factory -> factory.supportsSourceIdentifier(sourceIdentifier), factory -> factory.createPolicyPointcutParameters(sourceEvent.getContext().getOriginatingFlowName(), sourceIdentifier, sourceEvent.getMessage().getAttributes()));
    }

    private PolicyPointcutParameters createOperationPointcutParameters(ComponentIdentifier operationIdentifier, Map<String, Object> operationParameters, String originatingFlowName) {
        return this.createPointcutParameters(operationIdentifier, originatingFlowName, OperationPolicyPointcutParametersFactory.class, this.operationPointcutFactories, factory -> factory.supportsOperationIdentifier(operationIdentifier), factory -> factory.createPolicyPointcutParameters(originatingFlowName, operationIdentifier, operationParameters));
    }

    private <T> PolicyPointcutParameters createPointcutParameters(ComponentIdentifier componentIdentifier, String flowName, Class<T> factoryType, Collection<T> factories, Predicate<T> factoryFilter, Function<T, PolicyPointcutParameters> policyPointcutParametersCreationFunction) {
        List policyPointcutParametersFactories = factories.stream().filter(factoryFilter).collect(Collectors.toList());
        if (policyPointcutParametersFactories.size() > 1) {
            return this.throwMoreThanOneFactoryFoundException(componentIdentifier, factoryType);
        }
        if (policyPointcutParametersFactories.isEmpty()) {
            return new PolicyPointcutParameters(flowName, componentIdentifier);
        }
        return policyPointcutParametersCreationFunction.apply(policyPointcutParametersFactories.get(0));
    }

    private PolicyPointcutParameters throwMoreThanOneFactoryFoundException(ComponentIdentifier sourceIdentifier, Class factoryClass) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("More than one %s for component %s was found. There should be only one.", factoryClass.getName(), sourceIdentifier)));
    }

    @Override
    public void disposePoliciesResources(String executionIdentifier) {
        this.policyStateHandler.destroyState(executionIdentifier);
    }
}

