/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes.factory;

import java.io.InputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingManagerAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;
import org.mule.runtime.core.internal.streaming.bytes.FileStoreCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.factory.AbstractCursorStreamProviderFactory;
import org.mule.runtime.core.streaming.bytes.FileStoreCursorStreamConfig;

public class FileStoreCursorStreamProviderFactory
extends AbstractCursorStreamProviderFactory {
    private final FileStoreCursorStreamConfig config;
    private final ScheduledExecutorService executorService;

    public FileStoreCursorStreamProviderFactory(ByteStreamingManagerAdapter streamingManager, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager, ScheduledExecutorService executorService) {
        super(streamingManager, bufferManager);
        this.config = config;
        this.executorService = executorService;
    }

    @Override
    protected Either<CursorStreamProviderAdapter, InputStream> resolve(InputStream inputStream, Event event) {
        return Either.left(new FileStoreCursorStreamProvider(inputStream, this.config, event, this.getBufferManager(), this.executorService));
    }
}

