/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.streaming.CursorStream;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingManagerAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;
import org.mule.runtime.core.internal.streaming.bytes.DefaultByteStreamingStatistics;
import org.mule.runtime.core.internal.streaming.bytes.factory.FileStoreCursorStreamProviderFactory;
import org.mule.runtime.core.internal.streaming.bytes.factory.InMemoryCursorStreamProviderFactory;
import org.mule.runtime.core.internal.streaming.bytes.factory.NullCursorStreamProviderFactory;
import org.mule.runtime.core.streaming.bytes.ByteStreamingStatistics;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.streaming.bytes.FileStoreCursorStreamConfig;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultByteStreamingManager
implements ByteStreamingManagerAdapter,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultByteStreamingManager.class);
    private final LoadingCache<String, EventStreamingState> registry = CacheBuilder.newBuilder().removalListener(notification -> EventStreamingState.access$400((EventStreamingState)notification.getValue())).build((CacheLoader)new CacheLoader<String, EventStreamingState>(){

        public EventStreamingState load(String key) throws Exception {
            return new EventStreamingState();
        }
    });
    private final DefaultByteStreamingStatistics statistics = new DefaultByteStreamingStatistics();
    private final ByteBufferManager bufferFactory;
    private final Scheduler executorService;
    private final MuleContext muleContext;

    public DefaultByteStreamingManager(ByteBufferManager bufferFactory, Scheduler executorService, MuleContext muleContext) {
        this.bufferFactory = bufferFactory;
        this.executorService = executorService;
        this.muleContext = muleContext;
    }

    public void dispose() {
        this.executorService.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CursorStreamProviderFactory getInMemoryCursorStreamProviderFactory(InMemoryCursorStreamConfig config) {
        return new InMemoryCursorStreamProviderFactory(this, config, this.bufferFactory);
    }

    @Override
    public CursorStreamProviderFactory getFileStoreCursorStreamProviderFactory(FileStoreCursorStreamConfig config) {
        return new FileStoreCursorStreamProviderFactory(this, config, this.bufferFactory, (ScheduledExecutorService)this.executorService);
    }

    @Override
    public CursorStreamProviderFactory getNullCursorStreamProviderFactory() {
        return new NullCursorStreamProviderFactory(this);
    }

    @Override
    public CursorStreamProviderFactory getDefaultCursorStreamProviderFactory() {
        return new InMemoryCursorStreamProviderFactory(this, InMemoryCursorStreamConfig.getDefault(), this.bufferFactory);
    }

    @Override
    public ByteStreamingStatistics getByteStreamingStatistics() {
        return this.statistics;
    }

    @Override
    public void onOpen(CursorStreamProviderAdapter provider) {
        ((EventStreamingState)this.registry.getUnchecked((Object)this.getEventId(provider))).addProvider(provider);
        this.statistics.incrementOpenProviders();
    }

    @Override
    public void onOpen(CursorStreamAdapter cursor) {
        CursorStreamProviderAdapter provider = cursor.getProvider();
        ((EventStreamingState)this.registry.getUnchecked((Object)this.getEventId(provider))).addCursor(provider, cursor);
        this.statistics.incrementOpenCursors();
    }

    @Override
    public void onClose(CursorStreamAdapter cursor) {
        String eventId = this.getEventId(cursor.getProvider());
        EventStreamingState state = (EventStreamingState)this.registry.getIfPresent((Object)eventId);
        if (state != null && state.removeCursor(cursor.getProvider(), cursor) == Status.DISPOSABLE) {
            state.dispose();
            this.registry.invalidate((Object)eventId);
        }
    }

    @Override
    public void success(Event event) {
        this.terminated(event, false);
    }

    @Override
    public void error(Event event) {
        this.terminated(event, true);
    }

    private void terminated(Event event, boolean error) {
        EventStreamingState state;
        if (!event.getContext().isStreaming()) {
            return;
        }
        EventContext rootContext = this.getRoot(event.getContext());
        if (rootContext.isTerminated() && (state = (EventStreamingState)this.registry.getIfPresent((Object)rootContext.getId())) != null && state.terminate(error) == Status.DISPOSABLE) {
            state.dispose();
            this.registry.invalidate((Object)rootContext.getId());
        }
    }

    private String getEventId(CursorStreamProviderAdapter provider) {
        return this.getEventId(provider.getCreatorEvent().getContext());
    }

    private String getEventId(EventContext eventContext) {
        return eventContext.getParentContext().map(this::getEventId).orElse(eventContext.getId());
    }

    private EventContext getRoot(EventContext eventContext) {
        return eventContext.getParentContext().map(this::getRoot).orElse(eventContext);
    }

    private class EventStreamingState {
        private Status status = Status.NORMAL;
        private boolean disposed = false;
        private final LoadingCache<CursorStreamProviderAdapter, List<CursorStreamAdapter>> cursors = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CursorStreamProviderAdapter, List<CursorStreamAdapter>>(){

            public List<CursorStreamAdapter> load(CursorStreamProviderAdapter key) throws Exception {
                return new LinkedList<CursorStreamAdapter>();
            }
        });

        private EventStreamingState() {
        }

        private synchronized void addProvider(CursorStreamProviderAdapter adapter) {
            this.cursors.getUnchecked((Object)adapter);
        }

        private Status terminate(boolean error) {
            if (this.cursors.size() == 0L) {
                this.status = Status.DISPOSABLE;
            } else {
                boolean allCursorsClosed = true;
                if (error) {
                    this.cursors.asMap().forEach((provider, cursors) -> {
                        this.closeProvider((CursorStreamProviderAdapter)provider);
                        this.closeAll((List<CursorStreamAdapter>)cursors);
                    });
                } else {
                    for (Map.Entry entry : this.cursors.asMap().entrySet()) {
                        this.closeProvider((CursorStreamProviderAdapter)entry.getKey());
                        List cursors2 = (List)entry.getValue();
                        if (cursors2.isEmpty()) continue;
                        allCursorsClosed = allCursorsClosed && cursors2.stream().allMatch(CursorStream::isClosed);
                    }
                }
                this.status = allCursorsClosed ? Status.DISPOSABLE : Status.SURVIVOR;
            }
            return this.status;
        }

        private void addCursor(CursorStreamProviderAdapter provider, CursorStreamAdapter cursor) {
            ((List)this.cursors.getUnchecked((Object)provider)).add(cursor);
        }

        private Status removeCursor(CursorStreamProviderAdapter provider, CursorStreamAdapter cursor) {
            List openCursors = (List)this.cursors.getUnchecked((Object)provider);
            if (openCursors.remove((Object)cursor)) {
                DefaultByteStreamingManager.this.statistics.decrementOpenCursors();
            }
            if (openCursors.isEmpty() && (provider.isClosed() || this.status == Status.SURVIVOR)) {
                this.dispose();
                this.status = Status.DISPOSABLE;
                this.cursors.invalidate((Object)provider);
            }
            return this.status;
        }

        private void dispose() {
            if (this.disposed) {
                return;
            }
            this.cursors.asMap().forEach((provider, cursors) -> {
                try {
                    this.closeProvider((CursorStreamProviderAdapter)provider);
                    this.closeAll((List<CursorStreamAdapter>)cursors);
                }
                finally {
                    provider.releaseResources();
                }
            });
            this.disposed = true;
        }

        private void closeAll(List<CursorStreamAdapter> cursors) {
            cursors.forEach(cursor -> {
                try {
                    cursor.close();
                    DefaultByteStreamingManager.this.statistics.decrementOpenCursors();
                }
                catch (Exception e) {
                    LOGGER.warn("Exception was found trying to close cursor. Execution will continue", (Throwable)e);
                }
            });
        }

        private void closeProvider(CursorStreamProviderAdapter provider) {
            if (!provider.isClosed()) {
                provider.close();
                DefaultByteStreamingManager.this.statistics.decrementOpenProviders();
            }
        }
    }

    static enum Status {
        NORMAL,
        SURVIVOR,
        DISPOSABLE;

    }
}

