/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;

abstract class BaseCursorStream
extends CursorStreamAdapter {
    private final CursorStreamProviderAdapter provider;
    private boolean closed = false;
    private boolean disposed = false;
    protected long position = 0L;
    private long mark = 0L;

    public BaseCursorStream(CursorStreamProviderAdapter provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"provider cannot be null");
        this.provider = provider;
    }

    @Override
    public CursorStreamProviderAdapter getProvider() {
        return this.provider;
    }

    public long getPosition() {
        return this.position;
    }

    public void seek(long position) throws IOException {
        this.assertNotDisposed();
        this.position = position;
        this.closed = false;
    }

    public final void close() throws IOException {
        this.closed = true;
        if (!this.disposed) {
            this.disposed = true;
            this.dispose();
        }
    }

    public final int read() throws IOException {
        this.assertNotDisposed();
        return this.handleAutoClose(this.doRead());
    }

    protected abstract int doRead() throws IOException;

    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotDisposed();
        return this.handleAutoClose(this.doRead(b, off, len));
    }

    protected abstract int doRead(byte[] var1, int var2, int var3) throws IOException;

    public final long skip(long n) throws IOException {
        this.seek(this.position + n);
        return n;
    }

    public synchronized void mark(int readlimit) {
        this.mark = readlimit;
    }

    public synchronized void reset() throws IOException {
        this.seek(this.mark);
    }

    public boolean markSupported() {
        return true;
    }

    public boolean isClosed() {
        return this.closed || this.disposed;
    }

    protected abstract void dispose();

    protected void assertNotDisposed() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (String)"Stream is closed");
    }

    protected int unsigned(int value) {
        return value & 0xFF;
    }

    private int handleAutoClose(int read) {
        if (read < 0) {
            this.closed = true;
        }
        return read;
    }
}

