/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.Range;
import org.mule.runtime.core.util.func.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamBuffer
implements InputStreamBuffer {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamBuffer.class);
    private final Lock bufferLock = new ReentrantLock();
    private InputStream stream;
    private final ByteBufferManager bufferManager;
    private ReadableByteChannel streamChannel;
    private ByteBuffer buffer;
    private boolean closed = false;
    private Range bufferRange;
    private boolean streamFullyConsumed = false;

    public AbstractInputStreamBuffer(InputStream stream, ByteBufferManager bufferManager, int bufferSize) {
        this(stream, AbstractInputStreamBuffer.openStreamChannel(stream), bufferManager, bufferSize);
    }

    public AbstractInputStreamBuffer(InputStream stream, ReadableByteChannel streamChannel, ByteBufferManager bufferManager, int bufferSize) {
        this(stream, streamChannel, bufferManager, bufferManager.allocate(bufferSize));
    }

    public AbstractInputStreamBuffer(InputStream stream, ReadableByteChannel streamChannel, ByteBufferManager bufferManager, ByteBuffer buffer) {
        this.stream = stream;
        this.streamChannel = streamChannel;
        this.bufferManager = bufferManager;
        this.buffer = buffer;
        this.bufferRange = new Range(0L, 0L);
    }

    protected static ReadableByteChannel openStreamChannel(InputStream stream) {
        return stream != null ? Channels.newChannel(stream) : null;
    }

    protected abstract int consumeForwardData(ByteBuffer var1) throws IOException;

    protected abstract int getBackwardsData(ByteBuffer var1, Range var2, int var3);

    protected abstract boolean canBeExpanded();

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    @Override
    public final void close() {
        this.closed = true;
        this.doClose();
        if (this.streamChannel != null) {
            this.safely(this.streamChannel::close);
        }
        if (this.stream != null) {
            this.safely(this.stream::close);
        }
        this.deallocate(this.buffer);
    }

    protected abstract void doClose();

    protected void yield() {
        this.streamChannel = null;
        this.stream = null;
        this.buffer = null;
    }

    @Override
    public final int get(ByteBuffer destination, long position, int length) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Buffer is closed");
        return this.doGet(destination, position, length, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doGet(ByteBuffer dest, long position, int length, boolean consumeStreamIfNecessary) {
        Range requiredRange = new Range(position, position + (long)length);
        this.acquireBufferLock();
        try {
            if (this.streamFullyConsumed && requiredRange.startsAfter(this.bufferRange)) {
                int n = -1;
                return n;
            }
            if (this.bufferRange.contains(requiredRange)) {
                int n = this.copy(dest, requiredRange);
                return n;
            }
            if (this.bufferRange.isAhead(requiredRange)) {
                int n = this.getBackwardsData(dest, requiredRange, length);
                return n;
            }
            int overlap = this.handlePartialOverlap(dest, requiredRange);
            if (overlap > 0) {
                int n = overlap;
                return n;
            }
            if (consumeStreamIfNecessary) {
                while (!this.streamFullyConsumed && this.bufferRange.isBehind(requiredRange)) {
                    try {
                        if (this.reloadBuffer() <= 0 || (overlap = this.handlePartialOverlap(dest, requiredRange)) <= 0) continue;
                        int n = overlap;
                        return n;
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not read stream"), (Throwable)e);
                    }
                }
                int n = this.doGet(dest, position, length, false);
                return n;
            }
            int n = this.handlePartialOverlap(dest, requiredRange);
            return n;
        }
        finally {
            this.releaseBufferLock();
        }
    }

    protected void consume(ByteBuffer data) {
        int read = data.remaining();
        if (read > 0) {
            this.buffer.put(data);
            this.bufferRange = this.bufferRange.advance(read);
        }
    }

    protected void releaseBufferLock() {
        try {
            this.bufferLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    protected void acquireBufferLock() {
        this.bufferLock.lock();
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    private int reloadBuffer() throws IOException {
        if (this.streamFullyConsumed) {
            return -1;
        }
        int result = this.consumeForwardData(this.buffer);
        if (result >= 0) {
            this.bufferRange = this.bufferRange.advance(result);
        } else {
            this.streamFullyConsumed();
        }
        return result;
    }

    protected int loadFromStream(ByteBuffer buffer) throws IOException {
        int result;
        try {
            result = this.streamChannel.read(buffer);
        }
        catch (ClosedChannelException e) {
            result = -1;
        }
        return result;
    }

    protected ByteBuffer expandBuffer(int bytesIncrement) {
        ByteBuffer newBuffer = this.bufferManager.allocate(this.getExpandedBufferSize(bytesIncrement));
        this.buffer.position(0);
        newBuffer.put(this.buffer);
        ByteBuffer oldBuffer = this.buffer;
        this.buffer = newBuffer;
        this.deallocate(oldBuffer);
        return this.buffer;
    }

    protected void deallocate(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            this.safely(() -> this.bufferManager.deallocate(byteBuffer));
        }
    }

    protected InputStream getStream() {
        return this.stream;
    }

    protected ReadableByteChannel getStreamChannel() {
        return this.streamChannel;
    }

    protected int getExpandedBufferSize(int bytesIncrement) {
        return this.buffer.capacity() + bytesIncrement;
    }

    protected void streamFullyConsumed() {
        this.streamFullyConsumed = true;
    }

    private int handlePartialOverlap(ByteBuffer dest, Range requiredRange) {
        return this.bufferRange.overlap(requiredRange).filter(r -> !r.isEmpty()).map(overlap -> this.copy(dest, (Range)overlap)).orElse(-1);
    }

    protected int copy(ByteBuffer dest, Range requiredRange) {
        ByteBuffer src = this.buffer.duplicate();
        int newPosition = requiredRange.start >= (long)this.buffer.limit() ? Math.toIntExact(requiredRange.start - this.bufferRange.start) : Math.toIntExact(requiredRange.start);
        src.position(newPosition);
        src.limit(newPosition + Math.min(dest.remaining(), Math.min(requiredRange.length(), src.remaining())));
        if (src.hasRemaining()) {
            int remaining = src.remaining();
            dest.put(src);
            return remaining;
        }
        return -1;
    }

    private void safely(CheckedRunnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            LOGGER.debug("Found exception closing buffer", (Throwable)e);
        }
    }
}

