/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.streaming.CursorStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;

public abstract class AbstractCursorStreamProviderAdapter
implements CursorStreamProviderAdapter {
    protected final InputStream wrappedStream;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Event creatorEvent;
    private final ByteBufferManager bufferManager;

    public AbstractCursorStreamProviderAdapter(InputStream wrappedStream, ByteBufferManager bufferManager, Event event) {
        this.wrappedStream = wrappedStream;
        this.bufferManager = bufferManager;
        this.creatorEvent = event;
    }

    public final CursorStream openCursor() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"Cannot open a new cursor on a closed stream");
        return this.doOpenCursor();
    }

    public void close() {
        this.closed.set(true);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Event getCreatorEvent() {
        return this.creatorEvent;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract CursorStream doOpenCursor();
}

