/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public final class ErrorTypeHandlerConnectionProviderWrapper<C>
extends ConnectionProviderWrapper<C> {
    private final ErrorTypeRepository errorTypeRepository;
    private final String namespace;
    private final RetryPolicyTemplate retryPolicyTemplate;

    public ErrorTypeHandlerConnectionProviderWrapper(ConnectionProvider<C> connectionProvider, MuleContext muleContext, ExtensionModel extensionModel, RetryPolicyTemplate retryPolicyTemplate) {
        super(connectionProvider);
        this.errorTypeRepository = muleContext.getErrorTypeRepository();
        this.namespace = extensionModel.getXmlDslModel().getNamespace().toUpperCase();
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    @Override
    public C connect() throws ConnectionException {
        try {
            return (C)this.getDelegate().connect();
        }
        catch (ConnectionException e) {
            Throwable cause = e.getCause();
            throw this.getErrorType(cause).map(errorType -> e.getClass().equals(ConnectionException.class) ? new ConnectionException(e.getMessage(), e.getCause(), errorType) : new ConnectionException(e.getMessage(), (Throwable)e, errorType)).orElse(e);
        }
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        ConnectionValidationResult originalResult = this.getDelegate().validate(connection);
        if (originalResult.isValid()) {
            return originalResult;
        }
        Exception exception = originalResult.getException();
        return this.getErrorType(exception).map(type -> ConnectionValidationResult.failure((String)originalResult.getMessage(), (ErrorType)type, (Exception)exception)).orElse(originalResult);
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getRetryPolicyTemplate() : this.retryPolicyTemplate;
    }

    @Override
    public Optional<PoolingProfile> getPoolingProfile() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getPoolingProfile() : Optional.empty();
    }

    private Optional<ErrorType> getErrorType(Throwable exception) {
        if (exception instanceof ModuleException) {
            return this.getErrorType(((ModuleException)exception).getType());
        }
        return exception != null && exception.getCause() != null ? this.getErrorType(exception.getCause()) : Optional.empty();
    }

    private Optional<ErrorType> getErrorType(ErrorTypeDefinition errorType) {
        return this.errorTypeRepository.getErrorType(this.getIdentifier(errorType));
    }

    private ComponentIdentifier getIdentifier(ErrorTypeDefinition errorType) {
        return ComponentIdentifier.builder().withName(errorType.getType()).withNamespace(this.namespace).build();
    }
}

