/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.execution.SourceResultAdapter;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.internal.streaming.StreamingManagerAdapter;
import org.mule.runtime.core.policy.FailureSourcePolicyResult;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.core.util.message.MessageUtils;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ModuleFlowProcessingPhase
extends NotificationFiringProcessingPhase<ModuleFlowProcessingPhaseTemplate> {
    public static final String ENABLE_SOURCE_POLICIES_SYSTEM_PROPERTY = "enableSourcePolicies";
    private static Logger LOGGER = LoggerFactory.getLogger(ModuleFlowProcessingPhase.class);
    private final StreamingManagerAdapter streamingManager;
    private final PolicyManager policyManager;

    public ModuleFlowProcessingPhase(PolicyManager policyManager, StreamingManagerAdapter streamingManager) {
        this.policyManager = policyManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof ModuleFlowProcessingPhaseTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runPhase(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        block6: {
            try {
                MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                MessageSource messageSource = messageProcessContext.getMessageSource();
                ComponentIdentifier sourceIdentifier = messageProcessContext.getSourceIdentifier();
                Consumer<MessagingException> errorConsumer = this.getErrorConsumer(messageSource, template.getFailedExecutionResponseParametersFunction(), messageProcessContext, template, phaseResultNotifier);
                Event templateEvent = this.createEvent(template, messageProcessContext, sourceIdentifier);
                if (System.getProperty(ENABLE_SOURCE_POLICIES_SYSTEM_PROPERTY) == null) {
                    Reference eventReference = new Reference();
                    Mono.just((Object)templateEvent).doOnNext(request -> {
                        eventReference.set(request);
                        this.fireNotification(messageProcessContext.getMessageSource(), (Event)request, messageProcessContext.getFlowConstruct(), 801);
                    }).then(request -> Mono.from(template.routeEventAsync((Event)request))).doOnSuccess(this.getSuccessConsumer(messageSource, templateEvent, exceptionHandler, errorConsumer, messageProcessContext, phaseResultNotifier, template)).doOnError(MessagingException.class, errorConsumer).doOnError(Exceptions.UNEXPECTED_EXCEPTION_PREDICATE, throwable -> LOGGER.error("Unhandled exception processing request" + throwable)).doAfterTerminate((event, e) -> {
                        if (event == null) {
                            event = (Event)eventReference.get();
                        }
                        if (e != null) {
                            this.streamingManager.error((Event)event);
                        } else {
                            this.streamingManager.success((Event)event);
                        }
                    }).subscribe();
                    break block6;
                }
                Processor nextOperation = this.createFlowExecutionProcessor(messageSource, exceptionHandler, messageProcessContext, template);
                SourcePolicy policy = this.policyManager.createSourcePolicyInstance(sourceIdentifier, templateEvent, nextOperation, template);
                try {
                    Either<FailureSourcePolicyResult, SuccessSourcePolicyResult> sourcePolicyResult = policy.process(templateEvent);
                    Consumer<MessagingException> onExceptionFunction = messagingException -> {
                        messagingException.setProcessedEvent(ExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, messageProcessContext.getErrorTypeLocator()));
                        this.fireNotification(messageSource, messagingException.getEvent(), messageProcessContext.getFlowConstruct(), 806);
                        try {
                            template.sendFailureResponseToClient((MessagingException)((Object)messagingException), ((FailureSourcePolicyResult)sourcePolicyResult.getLeft()).getErrorResponseParameters(), this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException((Throwable)e);
                        }
                    };
                    Consumer<SuccessSourcePolicyResult> onSuccessFunction = successSourcePolicyResult -> {
                        Event flowExecutionResponse = successSourcePolicyResult.getFlowExecutionResult();
                        this.fireNotification(messageSource, flowExecutionResponse, messageProcessContext.getFlowConstruct(), 805);
                        ResponseCompletionCallback responseCompletationCallback = this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler);
                        if (flowExecutionResponse == null) {
                            flowExecutionResponse = Event.builder(templateEvent).message(Message.builder().nullPayload().build()).build();
                        }
                        Map<String, Object> responseParameters = ((SuccessSourcePolicyResult)sourcePolicyResult.getRight()).getResponseParameters();
                        Function<Event, Map<String, Object>> errorResponseParametersFunction = failureEvent -> ((SuccessSourcePolicyResult)sourcePolicyResult.getRight()).createErrorResponseParameters((Event)failureEvent);
                        try {
                            template.sendResponseToClient(flowExecutionResponse, responseParameters, errorResponseParametersFunction, responseCompletationCallback);
                        }
                        catch (MessagingException e) {
                            onExceptionFunction.accept(e);
                        }
                        catch (MuleException e) {
                            onExceptionFunction.accept(new MessagingException(flowExecutionResponse, e));
                        }
                    };
                    sourcePolicyResult.apply(failureSourcePolicyResult -> onExceptionFunction.accept(failureSourcePolicyResult.getMessagingException()), onSuccessFunction);
                }
                finally {
                    this.policyManager.disposePoliciesResources(templateEvent.getContext().getId());
                }
            }
            catch (Exception e2) {
                phaseResultNotifier.phaseFailure(e2);
            }
        }
    }

    private Event createEvent(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, ComponentIdentifier sourceIdentifier) throws MuleException {
        Message message = template.getMessage();
        Event templateEvent = Event.builder(DefaultEventContext.create(messageProcessContext.getFlowConstruct(), sourceIdentifier.getNamespace())).message(message).build();
        if (message.getPayload().getValue() instanceof SourceResultAdapter) {
            SourceResultAdapter adapter = (SourceResultAdapter)message.getPayload().getValue();
            Result result = adapter.getResult();
            Object resultValue = result.getOutput();
            message = resultValue instanceof Collection && adapter.isCollection() ? MessageUtils.toMessage(Result.builder().output(MessageUtils.toMessageCollection((Collection)resultValue, result.getMediaType().orElse(MediaType.ANY), adapter.getCursorStreamProviderFactory(), templateEvent)).attributes((Attributes)NullAttributes.NULL_ATTRIBUTES).mediaType(result.getMediaType().orElse(MediaType.ANY)).build()) : MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), adapter.getCursorStreamProviderFactory(), templateEvent);
            templateEvent = Event.builder(templateEvent).message(message).build();
        }
        return templateEvent;
    }

    private Consumer<MessagingException> getErrorConsumer(MessageSource messageSource, Function<Event, Map<String, Object>> errorParametersFunction, MessageProcessContext messageProcessContext, ModuleFlowProcessingPhaseTemplate template, PhaseResultNotifier phaseResultNotifier) {
        return messagingException -> {
            messagingException.setProcessedEvent(ExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, messageProcessContext.getErrorTypeLocator()));
            this.fireNotification(messageSource, messagingException.getEvent(), messageProcessContext.getFlowConstruct(), 806);
            try {
                template.sendFailureResponseToClient((MessagingException)((Object)messagingException), (Map)errorParametersFunction.apply(messagingException.getEvent()), this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
    }

    private Consumer<Event> getSuccessConsumer(MessageSource messageSource, Event request, MessagingExceptionHandler exceptionHandler, Consumer<MessagingException> onExceptionFunction, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier, ModuleFlowProcessingPhaseTemplate template) {
        return response -> {
            this.fireNotification(messageSource, (Event)response, messageProcessContext.getFlowConstruct(), 805);
            ResponseCompletionCallback responseCompletationCallback = this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler);
            if (response == null) {
                response = Event.builder(request).message(Message.builder().nullPayload().build()).build();
            }
            Map<String, Object> responseParameters = template.getSuccessfulExecutionResponseParametersFunction().apply((Event)response);
            Function<Event, Map<String, Object>> errorResponseParametersFunction = template.getFailedExecutionResponseParametersFunction();
            try {
                template.sendResponseToClient((Event)response, responseParameters, errorResponseParametersFunction, responseCompletationCallback);
            }
            catch (MessagingException e) {
                onExceptionFunction.accept(e);
            }
            catch (MuleException e) {
                onExceptionFunction.accept(new MessagingException((Event)response, e));
            }
        };
    }

    private Processor createFlowExecutionProcessor(MessageSource messageSource, MessagingExceptionHandler exceptionHandler, MessageProcessContext messageProcessContext, ModuleFlowProcessingPhaseTemplate template) {
        return muleEvent -> {
            try {
                TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(messageProcessContext.getFlowConstruct().getMuleContext(), messageProcessContext.getFlowConstruct(), messageProcessContext.getTransactionConfig() == null ? new MuleTransactionConfig() : messageProcessContext.getTransactionConfig(), exceptionHandler);
                Object response = transactionTemplate.execute(() -> {
                    this.fireNotification(messageSource, muleEvent, messageProcessContext.getFlowConstruct(), 801);
                    return template.routeEvent(muleEvent);
                });
                return response;
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        };
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                phaseResultNotifier.phaseFailure((Exception)((Object)e));
                return event;
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final MessagingExceptionHandler exceptionListener) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                return ModuleFlowProcessingPhase.this.executeCallback(() -> {
                    Event handleException = exceptionListener.handleException(e, event);
                    phaseResultNotifier.phaseSuccessfully();
                    return handleException;
                }, phaseResultNotifier);
            }
        };
    }

    private Event executeCallback(Callback callback, PhaseResultNotifier phaseResultNotifier) {
        try {
            return callback.execute();
        }
        catch (Exception callbackException) {
            phaseResultNotifier.phaseFailure(callbackException);
            throw new MuleRuntimeException((Throwable)callbackException);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    private static interface Callback {
        public Event execute() throws Exception;
    }
}

