/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component.simple;

import java.io.IOException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.runtime.core.util.IOUtils;

public class StaticComponent
implements Callable,
Initialisable,
MuleContextAware {
    private Object data;
    private String dataFile;
    private String prefix;
    private String postfix;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (this.dataFile != null) {
            try {
                this.data = IOUtils.getResourceAsString(this.dataFile, this.getClass());
            }
            catch (IOException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    @Override
    public Object onCall(MuleEventContext eventContext) throws Exception {
        if (this.data != null) {
            return this.data;
        }
        String eventData = eventContext.transformMessageToString(this.muleContext);
        if (this.prefix != null) {
            eventData = this.prefix + eventData;
        }
        if (this.postfix != null) {
            eventData = eventData + this.postfix;
        }
        return eventData;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

