/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.context.WorkManager;
import org.mule.runtime.core.work.ConcurrentWorkTracker;
import org.mule.runtime.core.work.TrackerWorkListenerWrapperFactory;
import org.mule.runtime.core.work.WorkListenerWrapperFactory;
import org.mule.runtime.core.work.WorkManagerHolder;
import org.mule.runtime.core.work.WorkTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingWorkManager
implements WorkManager {
    protected static final Logger logger = LoggerFactory.getLogger(TrackingWorkManager.class);
    public static final int DEFAULT_SLEEP_MILLIS = 50;
    public static final String MULE_WAIT_MILLIS = "mule.transport.dispose.wait";
    private final WorkManagerHolder delegateHolder;
    private final int shutdownTimeout;
    private final int waitMillis;
    private WorkTracker workTracker;
    private WorkListenerWrapperFactory workListenerWrapperFactory;

    public TrackingWorkManager(WorkManagerHolder workManagerHolder, int shutdownTimeout) {
        this.delegateHolder = workManagerHolder;
        this.workTracker = new ConcurrentWorkTracker();
        this.shutdownTimeout = shutdownTimeout;
        this.workListenerWrapperFactory = new TrackerWorkListenerWrapperFactory();
        this.waitMillis = TrackingWorkManager.getWaitMillis();
    }

    @Override
    public boolean isStarted() {
        return this.delegateHolder.getWorkManager().isStarted();
    }

    public void dispose() {
        if (logger.isDebugEnabled()) {
            logger.debug("Waiting for works to finish execution");
        }
        long initialMillis = System.currentTimeMillis();
        while (this.workTracker.pendingWorks().size() != 0 && !this.isTimeoutExpired(initialMillis)) {
            try {
                Thread.sleep(this.waitMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Stop waiting for works completion. There are %s works unfinished works", this.workTracker.pendingWorks().size()));
        }
        this.workTracker.dispose();
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            this.workTracker.addWork(runnable);
            this.delegateHolder.getWorkManager().execute(new TrackeableRunnable(runnable));
        }
        catch (RuntimeException e) {
            this.workTracker.removeWork(runnable);
            throw e;
        }
    }

    public void start() throws MuleException {
    }

    public void doWork(Work work) throws WorkException {
        this.workTracker.addWork((Runnable)work);
        try {
            this.delegateHolder.getWorkManager().doWork(work);
        }
        finally {
            this.workTracker.removeWork((Runnable)work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        this.workTracker.addWork((Runnable)work);
        try {
            this.delegateHolder.getWorkManager().doWork(work, startTimeout, execContext, workListener);
        }
        finally {
            this.workTracker.removeWork((Runnable)work);
        }
    }

    public long startWork(Work work) throws WorkException {
        try {
            this.workTracker.addWork((Runnable)work);
            TrackeableWork wrappedWork = new TrackeableWork(work);
            return this.delegateHolder.getWorkManager().startWork(wrappedWork);
        }
        catch (WorkException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
        catch (RuntimeException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        try {
            this.workTracker.addWork((Runnable)work);
            TrackeableWork trackeableWork = new TrackeableWork(work);
            return this.delegateHolder.getWorkManager().startWork(trackeableWork, startTimeout, execContext, this.workListenerWrapperFactory.create(work, workListener));
        }
        catch (WorkException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
        catch (RuntimeException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
    }

    public void scheduleWork(Work work) throws WorkException {
        try {
            this.workTracker.addWork((Runnable)work);
            TrackeableWork wrappedWork = new TrackeableWork(work);
            this.delegateHolder.getWorkManager().scheduleWork(wrappedWork);
        }
        catch (WorkException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
        catch (RuntimeException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        this.workTracker.addWork((Runnable)work);
        try {
            TrackeableWork trackeableWork = new TrackeableWork(work);
            this.delegateHolder.getWorkManager().scheduleWork(trackeableWork, startTimeout, execContext, this.workListenerWrapperFactory.create(work, workListener));
        }
        catch (WorkException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
        catch (RuntimeException e) {
            this.workTracker.removeWork((Runnable)work);
            throw e;
        }
    }

    private boolean isTimeoutExpired(long initialMillis) {
        return System.currentTimeMillis() - initialMillis > (long)this.shutdownTimeout;
    }

    public void setWorkListenerWrapperFactory(WorkListenerWrapperFactory workListenerWrapperFactory) {
        this.workListenerWrapperFactory = workListenerWrapperFactory;
    }

    public void setWorkTracker(WorkTracker workTracker) {
        this.workTracker = workTracker;
    }

    private static int getWaitMillis() {
        try {
            String property = System.getProperty(MULE_WAIT_MILLIS);
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return 50;
        }
    }

    private class TrackeableRunnable
    implements Runnable {
        private final Runnable runnable;

        public TrackeableRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                TrackingWorkManager.this.workTracker.removeWork(this.runnable);
            }
        }
    }

    private class TrackeableWork
    implements Work {
        private final Work work;

        public TrackeableWork(Work work) {
            this.work = work;
        }

        public void run() {
            try {
                this.work.run();
            }
            finally {
                TrackingWorkManager.this.workTracker.removeWork((Runnable)this.work);
            }
        }

        public void release() {
            this.work.release();
        }
    }
}

