/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.work;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.ResponseTimeoutException;
import org.mule.runtime.core.execution.MessageProcessorExecutionTemplate;
import org.mule.runtime.core.work.AbstractMuleEventWork;

public class ProcessingMuleEventWork
extends AbstractMuleEventWork {
    private MessageProcessorExecutionTemplate messageProcessorExecutionTemplate;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Processor messageProcessor;
    private Event resultEvent;
    private MuleException exception;

    public ProcessingMuleEventWork(Processor messageProcessor, Event muleEvent, MuleContext muleContext, FlowConstruct flowConstruct) {
        super(muleEvent);
        this.messageProcessorExecutionTemplate = MessageProcessorExecutionTemplate.createExecutionTemplate();
        this.messageProcessorExecutionTemplate.setMuleContext(muleContext);
        this.messageProcessorExecutionTemplate.setFlowConstruct(flowConstruct);
        this.messageProcessor = messageProcessor;
    }

    @Override
    protected void doRun() {
        try {
            this.resultEvent = this.messageProcessorExecutionTemplate.execute(this.messageProcessor, this.event);
        }
        catch (MuleException e) {
            this.exception = e;
        }
        finally {
            this.latch.countDown();
        }
    }

    public Event getResult(long timeout, TimeUnit timeUnit) throws InterruptedException, ResponseTimeoutException, MuleException {
        if (this.latch.await(timeout, timeUnit)) {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.resultEvent;
        }
        throw new ResponseTimeoutException(I18nMessageFactory.createStaticMessage((String)"Processing did not completed in time"), this.messageProcessor);
    }
}

