/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultXMLSecureFactories {
    private static final Log logger = LogFactory.getLog(DefaultXMLSecureFactories.class);

    public static DocumentBuilderFactory createDocumentBuilderFactory(Boolean externalEntities, Boolean expandEntities) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", externalEntities);
            factory.setExpandEntityReferences(expandEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", expandEntities == false);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't configure XML entity expansion for DocumentBuilderFactory, this could introduce XXE and BL vulnerabilities");
        }
        return factory;
    }

    public static SAXParserFactory createSaxParserFactory(Boolean externalEntities, Boolean expandEntities) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", externalEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", expandEntities == false);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't configure XML entity expansion for SAXParserFactory, this could introduce XXE and BL vulnerabilities");
        }
        return factory;
    }

    public static XMLInputFactory createXmlInputFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", externalEntities);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", expandEntities);
        return factory;
    }
}

