/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.store.AbstractObjectStore;

public class SimpleMemoryObjectStore<T extends Serializable>
extends AbstractObjectStore<T>
implements ListableObjectStore<T> {
    private Map<Serializable, T> map = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    protected boolean doContains(Serializable key) {
        return this.map.containsKey(key);
    }

    @Override
    protected void doStore(Serializable key, T value) throws ObjectStoreException {
        if (value == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("value"));
        }
        this.map.put(key, value);
    }

    @Override
    protected T doRetrieve(Serializable key) {
        return (T)((Serializable)this.map.get(key));
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.map.clear();
    }

    @Override
    protected T doRemove(Serializable key) {
        return (T)((Serializable)this.map.remove(key));
    }

    @Override
    public void open() throws ObjectStoreException {
    }

    @Override
    public void close() throws ObjectStoreException {
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        return new ArrayList<Serializable>(this.map.keySet());
    }
}

