/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.core.util.concurrent.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitoredObjectStore<T extends Serializable>
implements ObjectStore<T>,
Runnable,
MuleContextAware,
Initialisable,
Disposable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext context;
    protected ScheduledThreadPoolExecutor scheduler;
    protected int maxEntries = 4000;
    protected int entryTTL = -1;
    protected int expirationInterval = 1000;
    protected String name = null;

    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setThreadFactory(new DaemonThreadFactory(this.name + "-Monitor", this.getClass().getClassLoader()));
            this.scheduler.scheduleWithFixedDelay(this, 0L, this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public final void run() {
        if (this.context == null || this.context.isPrimaryPollingInstance()) {
            this.expire();
        }
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    protected MuleContext getMuleContext() {
        return this.context;
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setScheduler(ScheduledThreadPoolExecutor scheduler) {
        this.scheduler = scheduler;
    }

    public void setName(String id) {
        this.name = id;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public int getEntryTTL() {
        return this.entryTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public String getName() {
        return this.name;
    }

    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduler;
    }

    protected abstract void expire();
}

