/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.rx;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;

public class Exceptions {
    public static <T> Consumer<T> checkedConsumer(CheckedConsumer<T> checkedConsumer) {
        return t -> checkedConsumer.accept(t);
    }

    public static <T, U> BiConsumer<T, U> checkedConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return (t, u) -> checkedBiConsumer.accept(t, u);
    }

    public static <T, R> Function<T, R> checkedFunction(CheckedFunction<T, R> checkedFunction) {
        return t -> checkedFunction.apply(t);
    }

    public static <T, U, R> BiFunction<T, U, R> checkedFunction(CheckedBiFunction<T, U, R> checkedBiFunction) {
        return (t, u) -> checkedBiFunction.apply(t, u);
    }

    public static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> checkedPredicate) {
        return t -> checkedPredicate.test(t);
    }

    public static <T, U> BiPredicate<T, U> checkedPredicate(CheckedBiPredicate<T, U> checkedBiPredicate) {
        return (t, u) -> checkedBiPredicate.test(t, u);
    }

    public static MuleException rxExceptionToMuleException(Throwable throwable) throws MuleException {
        if ((throwable = reactor.core.Exceptions.unwrap((Throwable)throwable)) instanceof MuleException) {
            return (MuleException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new DefaultMuleException(throwable);
    }

    @FunctionalInterface
    public static interface CheckedBiPredicate<T, U>
    extends BiPredicate<T, U> {
        @Override
        default public boolean test(T t, U u) {
            try {
                return this.testChecked(t, u);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public boolean testChecked(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedPredicate<T>
    extends Predicate<T> {
        @Override
        default public boolean test(T t) {
            try {
                return this.testChecked(t);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public boolean testChecked(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<T, U, R>
    extends BiFunction<T, U, R> {
        @Override
        default public R apply(T t, U u) {
            try {
                return this.applyChecked(t, u);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public R applyChecked(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R>
    extends Function<T, R> {
        @Override
        default public R apply(T t) {
            try {
                return this.applyChecked(t);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public R applyChecked(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<T, U>
    extends BiConsumer<T, U> {
        @Override
        default public void accept(T t, U u) {
            try {
                this.acceptChecked(t, u);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public void acceptChecked(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptChecked(t);
            }
            catch (Throwable throwable) {
                throw reactor.core.Exceptions.propagate((Throwable)throwable);
            }
        }

        public void acceptChecked(T var1) throws Throwable;
    }
}

