/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue.objectstore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.QueueStore;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.core.util.queue.Queue;
import org.mule.runtime.core.util.queue.QueueConfiguration;
import org.mule.runtime.core.util.queue.QueueManager;
import org.mule.runtime.core.util.queue.QueueSession;
import org.mule.runtime.core.util.queue.objectstore.QueueInfo;
import org.mule.runtime.core.util.queue.objectstore.QueueKey;
import org.mule.runtime.core.util.queue.objectstore.QueueTransactionContext;
import org.mule.runtime.core.util.queue.objectstore.TransactionalQueueSession;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractTransactionContext;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractXAResourceManager;
import org.mule.runtime.core.util.xa.ResourceManagerException;
import org.mule.runtime.core.util.xa.ResourceManagerSystemException;

@Deprecated
public class TransactionalQueueManager
extends AbstractXAResourceManager
implements QueueManager,
MuleContextAware {
    private final Map<String, QueueInfo> queues = new HashMap<String, QueueInfo>();
    private org.mule.runtime.core.util.queue.objectstore.QueueConfiguration defaultQueueConfiguration;
    private MuleContext muleContext;
    private final Set<QueueStore> queueObjectStores = new HashSet<QueueStore>();
    private final Set<ListableObjectStore> listableObjectStores = new HashSet<ListableObjectStore>();
    private final ReadWriteLock queuesLock = new ReentrantReadWriteLock();

    @Override
    public synchronized QueueSession getQueueSession() {
        return new TransactionalQueueSession(this, this);
    }

    @Override
    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = (org.mule.runtime.core.util.queue.objectstore.QueueConfiguration)config;
        this.addStore(((org.mule.runtime.core.util.queue.objectstore.QueueConfiguration)config).objectStore);
    }

    @Override
    public synchronized void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.getQueue(queueName, (org.mule.runtime.core.util.queue.objectstore.QueueConfiguration)config).setConfig((org.mule.runtime.core.util.queue.objectstore.QueueConfiguration)config);
        this.addStore(((org.mule.runtime.core.util.queue.objectstore.QueueConfiguration)config).objectStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeQueue(Queue queue) throws MuleException, InterruptedException {
        if (queue == null) {
            throw new IllegalArgumentException("Queue to be disposed cannot be null");
        }
        String queueName = queue.getName();
        Lock lock = this.queuesLock.writeLock();
        lock.lock();
        try {
            if (!this.queues.containsKey(queueName)) {
                throw new IllegalArgumentException(String.format("There's no queue for name %s", queueName));
            }
            this.queues.remove(queueName);
        }
        finally {
            lock.unlock();
        }
        queue.clear();
        if (queue instanceof Stoppable) {
            ((Stoppable)queue).stop();
        }
        if (queue instanceof Disposable) {
            ((Disposable)queue).dispose();
        }
    }

    protected QueueInfo getQueue(String name) {
        return this.getQueue(name, this.defaultQueueConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueInfo getQueue(String name, org.mule.runtime.core.util.queue.objectstore.QueueConfiguration config) {
        Lock lock = this.queuesLock.writeLock();
        lock.lock();
        try {
            QueueInfo q = this.queues.get(name);
            if (q == null) {
                q = new QueueInfo(name, this.muleContext, config);
                this.queues.put(name, q);
            }
            QueueInfo queueInfo = q;
            return queueInfo;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueInfo getQueueInfo(String name) {
        Lock lock = this.queuesLock.readLock();
        lock.lock();
        try {
            QueueInfo q = this.queues.get(name);
            QueueInfo queueInfo = q == null ? q : new QueueInfo(q);
            return queueInfo;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void doStart() throws ResourceManagerSystemException {
        this.findAllListableObjectStores();
        for (ListableObjectStore store : this.listableObjectStores) {
            try {
                store.open();
            }
            catch (ObjectStoreException e) {
                throw new ResourceManagerSystemException((Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shutdown(int mode, long timeoutMSecs) {
        Lock lock = this.queuesLock.writeLock();
        lock.lock();
        try {
            this.queues.clear();
        }
        finally {
            lock.unlock();
        }
        return super.shutdown(mode, timeoutMSecs);
    }

    @Override
    protected void recover() throws ResourceManagerSystemException {
        this.findAllQueueStores();
        for (QueueStore store : this.queueObjectStores) {
            if (!store.isPersistent()) continue;
            try {
                List<Serializable> keys = store.allKeys();
                for (Serializable key : keys) {
                    if (!(key instanceof QueueKey)) continue;
                    QueueKey queueKey = (QueueKey)key;
                    QueueInfo queue = this.getQueue(queueKey.queueName);
                    if (!queue.isQueueTransient()) continue;
                    queue.putNow(queueKey.id);
                }
            }
            catch (Exception e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    @Override
    protected AbstractTransactionContext createTransactionContext(Object session) {
        return new QueueTransactionContext(this);
    }

    @Override
    protected void doBegin(AbstractTransactionContext context) {
    }

    @Override
    protected int doPrepare(AbstractTransactionContext context) {
        return 0;
    }

    @Override
    protected void doCommit(AbstractTransactionContext context) throws ResourceManagerException {
        context.doCommit();
    }

    protected Serializable doStore(QueueInfo queue, Serializable object) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        String id = this.muleContext == null ? UUID.getUUID() : this.muleContext.getUniqueIdString();
        QueueKey key = new QueueKey(queue.getName(), (Serializable)((Object)id));
        store.store(key, object);
        return id;
    }

    protected void doClear(QueueInfo queue) throws ObjectStoreException, InterruptedException {
        queue.clear();
    }

    protected void doRemove(QueueInfo queue, Serializable id) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        QueueKey key = new QueueKey(queue.getName(), id);
        store.remove(key);
    }

    protected Serializable doLoad(QueueInfo queue, Serializable id) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        QueueKey key = new QueueKey(queue.getName(), id);
        return store.retrieve(key);
    }

    @Override
    protected void doRollback(AbstractTransactionContext context) throws ResourceManagerException {
        context.doRollback();
    }

    protected void findAllListableObjectStores() {
        if (this.muleContext != null) {
            for (ListableObjectStore store : this.muleContext.getRegistry().lookupByType(ListableObjectStore.class).values()) {
                this.addStore(store);
            }
        }
    }

    protected synchronized void findAllQueueStores() {
        if (this.muleContext != null) {
            for (QueueStore store : this.muleContext.getRegistry().lookupByType(QueueStore.class).values()) {
                this.addStore(store);
            }
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    private void addStore(ListableObjectStore<?> store) {
        if (store instanceof QueueStore) {
            this.queueObjectStores.add((QueueStore)store);
        }
        this.listableObjectStores.add(store);
    }
}

