/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long time;
    private final TimeUnit timeUnit;

    public WaitPolicy() {
        this(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public WaitPolicy(long time, TimeUnit timeUnit) {
        this.time = time < 0L ? Long.MAX_VALUE : time;
        this.timeUnit = timeUnit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        try {
            if (e.isShutdown()) {
                throw new RejectedExecutionException("ThreadPoolExecutor is already shut down");
            }
            if (!e.getQueue().offer(r, this.time, this.timeUnit)) {
                String message = String.format("ThreadPoolExecutor did not accept within %1d %2s", new Object[]{this.time, this.timeUnit});
                throw new RejectedExecutionException(message);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException(ie);
        }
    }
}

