/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.processor.InternalMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.DynamicMessageProcessorContainer;

public class NotificationUtils {
    private NotificationUtils() {
    }

    public static void addMessageProcessorPathElements(List<Processor> processors, MessageProcessorPathElement parentElement) {
        if (processors == null) {
            return;
        }
        processors.forEach(processor -> NotificationUtils.addMessageProcessorPathElements(processor, parentElement));
    }

    public static void addMessageProcessorPathElements(Processor processor, MessageProcessorPathElement parentElement) {
        if (processor == null || parentElement == null) {
            return;
        }
        if (!(processor instanceof InternalMessageProcessor)) {
            if (processor instanceof MessageProcessorContainer) {
                ((MessageProcessorContainer)((Object)processor)).addMessageProcessorPathElements(parentElement);
            } else {
                parentElement.addChild(processor);
            }
        }
    }

    public static FlowMap buildPathResolver(MessageProcessorPathElement element) {
        return new FlowMap(NotificationUtils.buildPaths(element, new LinkedHashMap<Processor, String>()));
    }

    @Deprecated
    public static Map<Processor, String> buildPaths(MessageProcessorPathElement element) {
        return NotificationUtils.buildPaths(element, new LinkedHashMap<Processor, String>());
    }

    private static Map<Processor, String> buildPaths(MessageProcessorPathElement element, Map<Processor, String> elements) {
        if (element.getMessageProcessor() != null) {
            elements.put(element.getMessageProcessor(), element.getPath());
        }
        List<MessageProcessorPathElement> children = element.getChildren();
        for (MessageProcessorPathElement child : children) {
            NotificationUtils.buildPaths(child, elements);
        }
        return elements;
    }

    public static class FlowMap
    implements PathResolver {
        private Map<Processor, String> flowMap = new ConcurrentHashMap<Processor, String>();
        private Set<Processor> resolvedDynamicContainers = Collections.synchronizedSet(new HashSet());

        public FlowMap(Map<Processor, String> paths) {
            this.flowMap.putAll(paths);
        }

        @Override
        public String resolvePath(Processor processor) {
            String path = this.flowMap.get(processor);
            if (path != null) {
                return path;
            }
            for (Map.Entry<Processor, String> flowMapEntries : this.flowMap.entrySet()) {
                FlowMap resolvedInnerPaths;
                if (!(flowMapEntries.getKey() instanceof DynamicMessageProcessorContainer) || this.resolvedDynamicContainers.contains(flowMapEntries.getKey()) || (resolvedInnerPaths = ((DynamicMessageProcessorContainer)flowMapEntries.getKey()).buildInnerPaths()) == null) continue;
                this.flowMap.putAll(resolvedInnerPaths.getFlowMap());
                this.resolvedDynamicContainers.add(flowMapEntries.getKey());
            }
            return this.flowMap.get(processor);
        }

        public Collection<String> getAllPaths() {
            return this.flowMap.values();
        }

        public Map<Processor, String> getFlowMap() {
            return this.flowMap;
        }
    }

    public static interface PathResolver {
        public String resolvePath(Processor var1);
    }
}

