/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.message.ds.ByteArrayDataSource;
import org.mule.runtime.core.message.ds.InputStreamDataSource;
import org.mule.runtime.core.message.ds.StringDataSource;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.FileUtils;
import org.mule.runtime.core.util.NumberUtils;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Log logger = LogFactory.getLog(IOUtils.class);
    protected static int bufferSize = NumberUtils.toInt((String)System.getProperty("mule.streaming.bufferSize"), (int)4096);

    public static String getResourceAsString(String resourceName, Class callingClass) throws IOException {
        Throwable throwable = null;
        try (InputStream is = IOUtils.getResourceAsStream(resourceName, callingClass);){
            if (is != null) {
                String string = IOUtils.toString(is);
                return string;
            }
            try {
                throw new IOException("Unable to load resource " + resourceName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        return IOUtils.getResourceAsStream(resourceName, callingClass, true, true);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) throws IOException {
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass, tryAsFile, tryAsUrl);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = FileUtils.newFile(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug((Object)("Unable to load resource from the file system: " + file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource from the file system: " + e.getMessage()));
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(() -> ClassUtils.getResource(resourceName, callingClass));
                if (url == null) {
                    logger.debug((Object)("Unable to load resource " + resourceName + " from the classpath"));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource " + resourceName + " from the classpath: " + e.getMessage()));
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String toString(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static byte[] toByteArray(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static DataHandler toDataHandler(String name, Object object, MediaType contentType) throws IOException {
        DataHandler dh = object instanceof File ? (contentType != null ? new DataHandler((Object)new FileInputStream((File)object), contentType.toString()) : new DataHandler((DataSource)new FileDataSource((File)object))) : (object instanceof URL ? (contentType != null ? new DataHandler((Object)((URL)object).openStream(), contentType.toString()) : new DataHandler((URL)object)) : (object instanceof String ? (contentType != null ? new DataHandler((DataSource)new StringDataSource((String)object, name, contentType)) : new DataHandler((DataSource)new StringDataSource((String)object, name))) : (object instanceof byte[] && contentType != null ? new DataHandler((DataSource)new ByteArrayDataSource((byte[])object, contentType, name)) : (object instanceof InputStream && contentType != null ? new DataHandler((DataSource)new InputStreamDataSource((InputStream)object, contentType, name)) : new DataHandler(object, contentType.toString())))));
        return dh;
    }

    public static InternalMessage toMuleMessagePart(String name, Object object, MediaType contentType) throws IOException {
        InternalMessage.Builder builder;
        if (object instanceof File) {
            builder = InternalMessage.builder().payload(new FileInputStream((File)object));
        } else if (object instanceof URL) {
            builder = InternalMessage.builder().payload(((URL)object).openStream());
        } else if (object instanceof String) {
            builder = InternalMessage.builder().payload(object);
            if (contentType == null || MediaType.ANY.matches(contentType)) {
                builder.mediaType(MediaType.TEXT);
            }
        } else {
            builder = InternalMessage.builder().payload(object);
        }
        if (contentType != null && !MediaType.ANY.matches(contentType)) {
            builder.mediaType(contentType);
        } else {
            DataHandler dataHandler = IOUtils.toDataHandler(name, object, contentType);
            builder.mediaType(MediaType.parse((String)dataHandler.getContentType()));
        }
        return builder.attributes(new PartAttributes(name)).build();
    }
}

