/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.ErrorMessageAwareException;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.ErrorMapping;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.TypedException;
import org.mule.runtime.core.exception.WrapperErrorMessageAwareException;
import org.mule.runtime.core.message.ErrorBuilder;
import org.mule.runtime.core.util.ExceptionHandler;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class ExceptionUtils
extends org.apache.commons.lang.exception.ExceptionUtils {
    public static boolean containsType(Throwable throwable, Class<?> type) {
        return ExceptionUtils.indexOfType((Throwable)throwable, type) > -1;
    }

    public static <ET> ET getDeepestOccurenceOfType(Throwable throwable, Class<ET> type) {
        if (throwable == null || type == null) {
            return null;
        }
        List throwableList = ExceptionUtils.getThrowableList((Throwable)throwable);
        ListIterator listIterator = throwableList.listIterator(throwableList.size());
        while (listIterator.hasPrevious()) {
            Throwable candidate = (Throwable)listIterator.previous();
            if (!type.isAssignableFrom(candidate.getClass())) continue;
            return (ET)candidate;
        }
        return null;
    }

    public static String getFullStackTraceWithoutMessages(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        for (String frame : ExceptionUtils.getStackFrames((Throwable)throwable)) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(SystemUtils.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static Optional<ConnectionException> extractConnectionException(Throwable throwable) {
        return ExceptionUtils.extractOfType(throwable, ConnectionException.class);
    }

    public static Optional<Throwable> extractCauseOfType(Throwable throwable, Class<? extends Throwable> throwableType) {
        Optional<? extends Throwable> typeThrowable = ExceptionUtils.extractOfType(throwable, throwableType);
        return typeThrowable.isPresent() ? Optional.ofNullable(typeThrowable.get().getCause()) : Optional.empty();
    }

    public static <T extends Throwable> Optional<T> extractOfType(Throwable throwable, Class<T> throwableType) {
        if (throwable == null || !ExceptionUtils.containsType(throwable, throwableType)) {
            return Optional.empty();
        }
        return Arrays.stream(ExceptionUtils.getThrowables((Throwable)throwable)).filter(throwableType::isInstance).findFirst();
    }

    public static <T, E extends Exception> T tryExpecting(Class<E> expectedExceptionType, Callable<T> callable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return exceptionHandler.handle(e);
        }
    }

    public static ErrorType getErrorTypeFromFailingProcessor(Object annotatedObject, Throwable exception, ErrorTypeLocator errorTypeLocator) {
        Optional<ErrorMapping> matchedErrorMapping;
        Throwable causeException = exception instanceof WrapperErrorMessageAwareException ? ((WrapperErrorMessageAwareException)((Object)exception)).getRootCause() : exception;
        ComponentIdentifier componentIdentifier = null;
        List errorMappings = null;
        if (AnnotatedObject.class.isAssignableFrom(annotatedObject.getClass())) {
            componentIdentifier = (ComponentIdentifier)((AnnotatedObject)annotatedObject).getAnnotation(ComponentIdentifier.ANNOTATION_NAME);
            errorMappings = (List)((AnnotatedObject)annotatedObject).getAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS);
        }
        ErrorType errorType = componentIdentifier != null ? errorTypeLocator.lookupComponentErrorType(componentIdentifier, causeException) : errorTypeLocator.lookupErrorType(causeException);
        if (errorMappings != null && !errorMappings.isEmpty() && (matchedErrorMapping = errorMappings.stream().filter(mapping -> mapping.match(errorType)).findFirst()).isPresent()) {
            return matchedErrorMapping.get().getTarget();
        }
        return errorType;
    }

    public static MessagingException putContext(MessagingException messagingException, Processor failingMessageProcessor, Event event, FlowConstruct flowConstruct, MuleContext muleContext) {
        for (ExceptionContextProvider exceptionContextProvider : muleContext.getExceptionContextProviders()) {
            for (Map.Entry<String, Object> contextInfoEntry : exceptionContextProvider.getContextInfo(event, failingMessageProcessor, flowConstruct).entrySet()) {
                if (messagingException.getInfo().containsKey(contextInfoEntry.getKey())) continue;
                messagingException.getInfo().put(contextInfoEntry.getKey(), contextInfoEntry.getValue());
            }
        }
        return messagingException;
    }

    public static Event createErrorEvent(Event currentEvent, Object annotatedObject, MessagingException messagingException, ErrorTypeLocator errorTypeLocator) {
        Object causeException = messagingException.getCause() != null ? messagingException.getCause() : messagingException;
        Optional error = messagingException.getEvent().getError();
        if (!(error.isPresent() && ((Error)error.get()).getCause().equals(causeException) && messagingException.causedExactlyBy(((Error)error.get()).getCause().getClass()))) {
            Error newError = ExceptionUtils.getErrorFromFailingProcessor(annotatedObject, (Throwable)causeException, errorTypeLocator);
            Event event = Event.builder(messagingException.getEvent()).error(newError).build();
            messagingException.setProcessedEvent(event);
            return event;
        }
        return currentEvent;
    }

    private static Error getErrorFromFailingProcessor(Object annotatedObject, Throwable causeException, ErrorTypeLocator errorTypeLocator) {
        ErrorType errorType;
        if (causeException instanceof TypedException) {
            errorType = ((TypedException)((Object)causeException)).getErrorType();
            causeException = causeException.getCause();
        } else {
            errorType = ExceptionUtils.getErrorTypeFromFailingProcessor(annotatedObject, causeException, errorTypeLocator);
        }
        return ErrorBuilder.builder(causeException).errorType(errorType).build();
    }

    public static Throwable getRootCauseException(Throwable exception) {
        return exception instanceof ErrorMessageAwareException ? ((ErrorMessageAwareException)((Object)exception)).getRootCause() : exception;
    }
}

