/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.regex.Pattern;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.metadata.DefaultTypedValue;

public class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*\\]$");
    private final String attributeValue;
    private ExtendedExpressionManager expressionManager;
    private AttributeType attributeType;

    public AttributeEvaluator(String attributeValue) {
        this.attributeValue = this.sanitize(attributeValue);
    }

    public AttributeEvaluator initialize(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        this.resolveAttributeType();
        return this;
    }

    private String sanitize(String attributeValue) {
        if (attributeValue != null) {
            attributeValue = attributeValue.trim().replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
        }
        return attributeValue;
    }

    private void resolveAttributeType() {
        this.attributeType = this.attributeValue != null && SINGLE_EXPRESSION_REGEX_PATTERN.matcher(this.attributeValue).matches() ? AttributeType.EXPRESSION : (this.attributeValue != null && this.isParseExpression(this.attributeValue) ? AttributeType.PARSE_EXPRESSION : AttributeType.STATIC_VALUE);
    }

    private boolean isParseExpression(String attributeValue) {
        int beginExpression = attributeValue.indexOf("#[");
        if (beginExpression == -1) {
            return false;
        }
        String remainingString = attributeValue.substring(beginExpression + "#[".length());
        return remainingString.contains("]");
    }

    public boolean isExpression() {
        return this.attributeType.equals((Object)AttributeType.EXPRESSION);
    }

    public boolean isParseExpression() {
        return this.attributeType.equals((Object)AttributeType.PARSE_EXPRESSION);
    }

    public TypedValue resolveTypedValue(Event event, Event.Builder eventBuilder) {
        if (this.isExpression()) {
            return this.expressionManager.evaluate(this.attributeValue, event, eventBuilder, null);
        }
        if (this.isParseExpression()) {
            String value = this.expressionManager.parse(this.attributeValue, event, null);
            return new DefaultTypedValue<String>(value, DataType.builder().type(String.class).build());
        }
        Class type = this.attributeValue == null ? Object.class : String.class;
        return new DefaultTypedValue<String>(this.attributeValue, DataType.builder().type(type).build());
    }

    public Object resolveValue(Event event) {
        if (this.isExpression()) {
            return this.expressionManager.evaluate(this.attributeValue, event).getValue();
        }
        if (this.isParseExpression()) {
            return this.expressionManager.parse(this.attributeValue, event, null);
        }
        return this.attributeValue;
    }

    public Integer resolveIntegerValue(Event event) {
        Object value = this.resolveValue(event);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Value was required as integer but is of type: %s", value.getClass().getName())));
    }

    public String resolveStringValue(Event event) {
        Object value = this.resolveValue(event);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Boolean resolveBooleanValue(Event event) {
        Object value = this.resolveValue(event);
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public String getRawValue() {
        return this.attributeValue;
    }

    private static enum AttributeType {
        EXPRESSION,
        PARSE_EXPRESSION,
        STATIC_VALUE;

    }
}

