/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.Collection;
import java.util.StringTokenizer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.SplashScreen;
import org.mule.runtime.core.util.SystemUtils;

public class ApplicationStartupSplashScreen
extends SplashScreen {
    @Override
    protected void doHeader(MuleContext context) {
        this.header.add("Application: " + context.getConfiguration().getId());
        this.header.add(String.format("OS encoding: %s, Mule encoding: %s", SystemUtils.FILE_SEPARATOR, context.getConfiguration().getDefaultEncoding()));
        this.header.add(" ");
    }

    @Override
    protected void doFooter(MuleContext context) {
        Collection<Agent> agents;
        if (!this.body.isEmpty()) {
            this.footer.add(" ");
        }
        if ((agents = context.getRegistry().lookupObjects(Agent.class)).size() == 0) {
            this.footer.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            this.footer.add(CoreMessages.agentsRunning().getMessage());
            for (Agent agent : agents) {
                String description = agent.getDescription();
                if (description.startsWith("'''")) {
                    description = description.substring("'''".length());
                    StringTokenizer st = new StringTokenizer(description, String.format("%n", new Object[0]));
                    while (st.hasMoreTokens()) {
                        this.footer.add("  " + st.nextToken());
                    }
                    continue;
                }
                this.footer.add("  " + description);
            }
        }
    }
}

