/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.IOUtils;

public class StringAppendTransformer
extends AbstractTransformer {
    private String message = "";

    public StringAppendTransformer() {
        this("");
    }

    public StringAppendTransformer(String message) {
        this.message = message;
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        String string;
        if (src instanceof byte[]) {
            string = new String((byte[])src);
        } else if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                string = IOUtils.toString(input);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        } else {
            string = (String)src;
        }
        return StringAppendTransformer.append(this.message, string);
    }

    public static String append(String append, String msg) {
        return msg + append;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

