/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;

public class CombineCollectionsTransformer
implements Processor {
    @Override
    public Event process(Event event) throws MuleException {
        InternalMessage msg = event.getMessage();
        ArrayList<Object> payload = new ArrayList<Object>();
        Class itemType = Object.class;
        if (DataType.MULE_MESSAGE_COLLECTION.isCompatibleWith(msg.getPayload().getDataType())) {
            itemType = InternalMessage.class;
            for (InternalMessage child : (Collection)msg.getPayload().getValue()) {
                Object childPayload = child.getPayload().getValue();
                if (childPayload instanceof Collection) {
                    payload.addAll((Collection)childPayload);
                    continue;
                }
                payload.add(childPayload);
            }
        } else if (msg.getPayload().getValue() instanceof Collection) {
            this.add(payload, (Collection)msg.getPayload().getValue());
        } else {
            itemType = msg.getPayload().getDataType().getType();
            payload.add(msg.getPayload().getValue());
        }
        InternalMessage listMessage = InternalMessage.builder(msg).collectionPayload(payload, itemType).build();
        return Event.builder(event).message(listMessage).build();
    }

    private void add(List<Object> newPayload, Collection existingPayload) {
        for (Object o : existingPayload) {
            if (o instanceof Collection) {
                newPayload.addAll((Collection)o);
                continue;
            }
            newPayload.add(o);
        }
    }
}

