/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        ObjectSerializer serializer = this.muleContext.getObjectSerializer();
        try {
            Object result = src instanceof byte[] ? serializer.getExternalProtocol().deserialize((byte[])src) : serializer.getExternalProtocol().deserialize((InputStream)src);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

