/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.simple.ByteArrayToSerializable;
import org.mule.runtime.core.util.IOUtils;

public class ByteArrayToObject
extends ByteArrayToSerializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src instanceof byte[]) {
            byte[] bytes = (byte[])src;
            if (this.checkStreamHeader(bytes[0])) {
                return super.doTransform(src, encoding);
            }
            return new String(bytes, encoding);
        }
        if (src instanceof InputStream) {
            String string;
            PushbackInputStream pushbackStream = new PushbackInputStream((InputStream)src);
            int firstByte = pushbackStream.read();
            pushbackStream.unread((byte)firstByte);
            if (this.checkStreamHeader((byte)firstByte)) {
                return super.doTransform(pushbackStream, encoding);
            }
            try {
                string = IOUtils.toString((InputStream)pushbackStream, (Charset)encoding);
            }
            catch (Throwable throwable) {
                try {
                    pushbackStream.close();
                    throw throwable;
                }
                catch (IOException iox) {
                    throw new TransformerException(this, (Throwable)iox);
                }
            }
            pushbackStream.close();
            return string;
        }
        throw new TransformerException(CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), src.getClass()));
    }

    private boolean checkStreamHeader(byte firstByte) {
        return firstByte == -84;
    }
}

