/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;

public class ByteArrayToHexString
extends AbstractTransformer {
    private volatile boolean upperCase = false;

    public ByteArrayToHexString() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.STRING);
    }

    public boolean getUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean value) {
        this.upperCase = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            return "";
        }
        try {
            byte[] bytes = null;
            if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    bytes = IOUtils.toByteArray(input);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            } else {
                bytes = (byte[])src;
            }
            return StringUtils.toHexString(bytes, this.upperCase);
        }
        catch (Exception ex) {
            throw new TransformerException(this, (Throwable)ex);
        }
    }
}

