/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.codec;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.XMLEntityCodec;

public class XmlEntityDecoder
extends AbstractTransformer {
    public XmlEntityDecoder() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            String data = src instanceof byte[] ? new String((byte[])src, encoding) : (src instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)src), (Charset)encoding) : (String)src);
            return XMLEntityCodec.decodeString(data);
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "XML"), this, (Throwable)ex);
        }
    }
}

