/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.codec;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.Base64;
import org.mule.runtime.core.util.IOUtils;

public class Base64Encoder
extends AbstractTransformer {
    public Base64Encoder() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            byte[] buf;
            if (src instanceof String) {
                buf = ((String)src).getBytes(encoding);
            } else if (src instanceof InputStream) {
                try (InputStreamReader input = new InputStreamReader((InputStream)src);){
                    buf = IOUtils.toByteArray((Reader)input, (Charset)encoding);
                }
            } else {
                buf = (byte[])src;
            }
            String result = Base64.encodeBytes(buf, 8);
            if (byte[].class.isAssignableFrom(this.getReturnDataType().getType())) {
                return result.getBytes(encoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "base64"), this, (Throwable)ex);
        }
    }
}

