/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.codec;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.Base64;
import org.mule.runtime.core.util.IOUtils;

public class Base64Decoder
extends AbstractTransformer {
    public Base64Decoder() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            String data;
            if (src instanceof byte[]) {
                data = new String((byte[])src, outputEncoding);
            } else if (src instanceof InputStream) {
                try (InputStream input = (InputStream)src;){
                    data = IOUtils.toString((InputStream)input, (Charset)outputEncoding);
                }
            } else {
                data = (String)src;
            }
            byte[] result = Base64.decode(data);
            if (DataType.STRING.isCompatibleWith(this.getReturnDataType())) {
                return new String(result, outputEncoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed("base64", this.getReturnDataType()), this, (Throwable)ex);
        }
    }
}

