/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import java.nio.charset.Charset;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;

public class TransformerTemplate
extends AbstractMessageTransformer {
    private TransformerCallback callback;

    public TransformerTemplate(TransformerCallback callback) {
        this.callback = callback;
    }

    @Override
    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        try {
            return this.callback.doTransform(event.getMessage());
        }
        catch (TransformerException e) {
            throw new TransformerException(e.getI18nMessage(), this, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public static class OverwitePayloadCallback
    implements TransformerCallback {
        private Object payload;

        public OverwitePayloadCallback(Object payload) {
            this.payload = payload;
        }

        @Override
        public Object doTransform(InternalMessage message) throws Exception {
            return this.payload;
        }
    }

    public static interface TransformerCallback {
        public Object doTransform(InternalMessage var1) throws Exception;
    }
}

