/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.serialization.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.serialization.SerializationException;
import org.mule.runtime.core.serialization.internal.AbstractSerializationProtocol;
import org.mule.runtime.core.util.SerializationUtils;

public class JavaExternalSerializerProtocol
extends AbstractSerializationProtocol {
    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        this.validateForSerialization(object);
        SerializationUtils.serialize((Serializable)((Serializable)object), (OutputStream)out);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        this.validateForSerialization(object);
        return SerializationUtils.serialize((Serializable)((Serializable)object));
    }

    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (String)"Cannot deserialize a null stream");
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"Cannot deserialize with a null classloader");
        return (T)SerializationUtils.deserialize(inputStream, classLoader, this.muleContext);
    }

    @Override
    protected <T> T postInitialize(T object) {
        return object;
    }

    private void validateForSerialization(Object object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new SerializationException(String.format("Was expecting a Serializable type. %s was found instead", object.getClass().getName()));
        }
    }
}

