/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.security;

import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.security.Authentication;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityContextFactory;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.security.DefaultSecurityContextFactory;

public abstract class AbstractSecurityProvider
implements SecurityProvider {
    private String name;
    private SecurityContextFactory securityContextFactory;

    public AbstractSecurityProvider(String name) {
        this.name = name;
    }

    public final void initialise() throws InitialisationException {
        this.doInitialise();
        if (this.securityContextFactory == null) {
            this.securityContextFactory = new DefaultSecurityContextFactory();
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public boolean supports(Class<?> aClass) {
        return Authentication.class.isAssignableFrom(aClass);
    }

    @Override
    public SecurityContext createSecurityContext(Authentication authentication) throws UnknownAuthenticationTypeException {
        return this.securityContextFactory.create(authentication);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityContextFactory getSecurityContextFactory() {
        return this.securityContextFactory;
    }

    public void setSecurityContextFactory(SecurityContextFactory securityContextFactory) {
        this.securityContextFactory = securityContextFactory;
    }
}

