/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.util.regex.Pattern;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.routing.filter.ObjectFilter;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExFilter
implements Filter,
ObjectFilter,
MuleContextAware,
Initialisable {
    private static final int NO_FLAGS = 0;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pattern pattern;
    private MuleContext muleContext;
    private int flags = 0;
    private AttributeEvaluator value;

    public void initialise() throws InitialisationException {
        if (this.value != null) {
            this.value.initialize(this.muleContext.getExpressionManager());
        }
    }

    public RegExFilter() {
    }

    public RegExFilter(String pattern) {
        this(pattern, null, 0);
    }

    public RegExFilter(String pattern, int flags) {
        this(pattern, null, flags);
    }

    public RegExFilter(String pattern, String value) {
        this(pattern, value, 0);
    }

    public RegExFilter(String pattern, String value, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
        this.flags = flags;
        this.value = new AttributeEvaluator(value);
    }

    @Override
    public boolean accept(InternalMessage message, Event.Builder builder) {
        Flow flowConstruct = new Flow("", this.muleContext);
        return this.accept(Event.builder(DefaultEventContext.create(flowConstruct, "RegExFilter")).message(message).exchangePattern(MessageExchangePattern.ONE_WAY).flow(flowConstruct).build(), builder);
    }

    @Override
    public boolean accept(Event event, Event.Builder builder) {
        try {
            if (this.value != null && this.value.getRawValue() != null) {
                return this.accept(this.value.resolveValue(event));
            }
            InternalMessage transformedMessage = this.muleContext.getTransformationService().transform(event.getMessage(), DataType.STRING);
            if (event.getMessage().getPayload().getDataType().isStreamType()) {
                builder.message(transformedMessage);
            }
            return this.accept(transformedMessage.getPayload().getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        Object tempObject = object;
        if (object instanceof byte[]) {
            ByteArrayToObject transformer = new ByteArrayToObject();
            try {
                object = transformer.transform(object);
            }
            catch (TransformerException e) {
                this.logger.warn(CoreMessages.transformFailedBeforeFilter().toString(), (Throwable)((Object)e));
                object = tempObject;
            }
        } else if (object instanceof char[]) {
            object = new String((char[])object);
        }
        return this.pattern != null && this.pattern.matcher(object.toString()).find();
    }

    public String getPattern() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public void setPattern(String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern, this.flags) : null;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.pattern = this.pattern != null ? Pattern.compile(this.pattern.pattern(), flags) : null;
    }

    public void setValue(String value) {
        this.value = new AttributeEvaluator(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegExFilter other = (RegExFilter)obj;
        boolean patternsAreEqual = ClassUtils.equal(this.pattern.pattern(), other.pattern.pattern());
        boolean flagsAreEqual = this.flags == other.flags;
        boolean valuesAreEquals = this.areValuesEqual(this.value, other.value);
        return patternsAreEqual && flagsAreEqual && valuesAreEquals;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.pattern, this.value == null ? null : this.value.getRawValue()});
    }

    private boolean areValuesEqual(AttributeEvaluator value1, AttributeEvaluator value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        if (value1.getRawValue() == null) {
            return value2.getRawValue() == null;
        }
        return value1.getRawValue().equals(value2.getRawValue());
    }
}

