/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.text.MessageFormat;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFilter
implements Filter,
MuleContextAware {
    protected final transient Logger logger = LoggerFactory.getLogger(ExpressionFilter.class);
    private ExpressionConfig config = new ExpressionConfig();
    private boolean nullReturnsTrue = false;
    private MuleContext muleContext;
    private Filter delegateFilter;

    public ExpressionFilter(String expression) {
        this.config.parse(expression);
    }

    public ExpressionFilter() {
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public boolean accept(InternalMessage message, Event.Builder builder) {
        String expr = this.getFullExpression();
        if (this.delegateFilter != null) {
            boolean result = this.delegateFilter.accept(message, builder);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format("Result of expression filter: {0} is: {1}", expr, result));
            }
            return result;
        }
        Flow flowConstruct = new Flow("", this.muleContext);
        return this.accept(Event.builder(DefaultEventContext.create(flowConstruct, "ExpressionFilter")).message(message).exchangePattern(MessageExchangePattern.ONE_WAY).flow(flowConstruct).build(), builder);
    }

    @Override
    public boolean accept(Event event, Event.Builder builder) {
        return ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> this.muleContext.getExpressionManager().evaluateBoolean(this.getFullExpression(), event, null, this.nullReturnsTrue, !this.nullReturnsTrue));
    }

    protected String getFullExpression() {
        return this.config.getExpression();
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }

    public boolean isNullReturnsTrue() {
        return this.nullReturnsTrue;
    }

    public void setNullReturnsTrue(boolean nullReturnsTrue) {
        this.nullReturnsTrue = nullReturnsTrue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionFilter other = (ExpressionFilter)obj;
        return ClassUtils.equal(this.config, other.config) && ClassUtils.equal(this.delegateFilter, other.delegateFilter) && this.nullReturnsTrue == other.nullReturnsTrue;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.config, this.delegateFilter, this.nullReturnsTrue});
    }
}

