/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.api.routing.RouterResultsHandler;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastingRoutingStrategy
extends AbstractRoutingStrategy {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RouterResultsHandler resultsHandler;

    public MulticastingRoutingStrategy(MuleContext muleContext, RouterResultsHandler resultAggregator) {
        super(muleContext);
        this.resultsHandler = resultAggregator;
    }

    @Override
    public Event route(Event event, List<Processor> messageProcessors) throws MuleException {
        InternalMessage message = event.getMessage();
        if (messageProcessors == null || messageProcessors.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), null);
        }
        ArrayList<Event> results = new ArrayList<Event>(messageProcessors.size());
        MulticastingRoutingStrategy.validateMessageIsNotConsumable(event, message);
        try {
            for (int i = 0; i < messageProcessors.size(); ++i) {
                Processor mp = messageProcessors.get(i);
                Event result = this.sendRequest(event, message, mp, true);
                if (result == null) continue;
                results.add(result);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(messageProcessors.get(0), e);
        }
        return this.resultsHandler.aggregateResults(results, event);
    }
}

