/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.Serializable;
import java.text.MessageFormat;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.store.ObjectStoreNotAvaliableException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.AbstractFilteringMessageProcessor;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentMessageFilter
extends AbstractFilteringMessageProcessor
implements Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentMessageFilter.class);
    protected volatile ObjectStore<String> store;
    protected String storePrefix;
    protected String idExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");
    protected String valueExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");

    public void initialise() throws InitialisationException {
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s.%s.%s", ThreadNameHelper.getPrefix(this.muleContext), this.flowConstruct.getName(), this.getClass().getName());
        }
        if (this.store == null) {
            this.store = this.createMessageIdStore();
        }
        LifecycleUtils.initialiseIfNeeded(this.store);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.store, LOGGER);
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        return objectStoreManager.getObjectStore(this.storePrefix, false, -1, 300000, 6000);
    }

    @Override
    protected Event processNext(Event event) throws MuleException {
        return super.processNext(event);
    }

    protected String getValueForEvent(Event event) throws MessagingException {
        return this.flowConstruct.getMuleContext().getExpressionManager().parse(this.valueExpression, event, this.flowConstruct);
    }

    protected String getIdForEvent(Event event) throws MuleException {
        return this.flowConstruct.getMuleContext().getExpressionManager().parse(this.idExpression, event, this.flowConstruct);
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore<String> getStore() {
        return this.store;
    }

    public void setStore(ObjectStore<String> store) {
        this.store = store;
    }

    @Override
    protected boolean accept(Event event, Event.Builder builder) {
        if (event != null && this.isNewMessage(event)) {
            try {
                String id = this.getIdForEvent(event);
                String value = this.getValueForEvent(event);
                try {
                    this.store.store((Serializable)((Object)id), value);
                    return true;
                }
                catch (ObjectAlreadyExistsException ex) {
                    return false;
                }
                catch (ObjectStoreNotAvaliableException e) {
                    this.logger.error("ObjectStore not available: " + e.getMessage());
                    return false;
                }
                catch (ObjectStoreException e) {
                    this.logger.warn("ObjectStore exception: " + e.getMessage());
                    return false;
                }
            }
            catch (MuleException e) {
                this.logger.warn("Could not retrieve Id or Value for event: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNewMessage(Event event) {
        try {
            String id = this.getIdForEvent(event);
            if (this.store == null) {
                IdempotentMessageFilter idempotentMessageFilter = this;
                synchronized (idempotentMessageFilter) {
                    this.initialise();
                }
            }
            return !this.store.contains((Serializable)((Object)id));
        }
        catch (MuleException e) {
            this.logger.error("Exception attempting to determine idempotency of incoming message for " + this.flowConstruct.getName() + " from the connector " + event.getContext().getOriginatingConnectorName(), (Throwable)e);
            return false;
        }
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }
}

