/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections.Factory;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessageRedeliveredException;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.processor.AbstractRedeliveryPolicy;
import org.mule.runtime.core.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.util.lock.LockFactory;
import org.mule.runtime.core.util.store.ObjectStorePartition;
import org.mule.runtime.core.util.store.ProvidedObjectStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private ObjectStore<AtomicInteger> store;
    private LockFactory lockFactory;
    private String idrId;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            try {
                MessageDigest.getInstance(this.messageDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Exception '%s' initializing message digest algorithm %s", e.getMessage(), this.messageDigestAlgorithm)), (Initialisable)this);
            }
        }
        String appName = this.muleContext.getConfiguration().getId();
        String flowName = this.flowConstruct.getName();
        this.idrId = String.format("%s-%s-%s", appName, flowName, "idr");
        this.lockFactory = this.muleContext.getLockFactory();
        if (this.store == null) {
            this.store = new ProvidedObjectStoreWrapper<AtomicInteger>(null, this.internalObjectStoreFactory());
        }
        LifecycleUtils.initialiseIfNeeded(this.objectToByteArray, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.byteArrayToHexString, this.muleContext);
    }

    protected Factory internalObjectStoreFactory() {
        return () -> {
            ObjectStoreManager objectStoreManager = this.muleContext.getObjectStoreManager();
            return objectStoreManager.getObjectStore(this.flowConstruct.getName() + "." + this.getClass().getName(), false, -1, 300000, 6000);
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.store != null) {
            if (this.store instanceof ObjectStorePartition) {
                try {
                    ((ObjectStorePartition)this.store).close();
                }
                catch (ObjectStoreException e) {
                    this.logger.warn("error closing object store: " + e.getMessage(), (Throwable)((Object)e));
                }
            }
            this.store = null;
        }
        if (this.deadLetterQueue instanceof Disposable) {
            ((Disposable)this.deadLetterQueue).dispose();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.deadLetterQueue instanceof Startable) {
            ((Startable)this.deadLetterQueue).start();
        }
    }

    @Override
    public Event process(Event event) throws MuleException {
        boolean exceptionSeen = false;
        boolean tooMany = false;
        AtomicInteger counter = null;
        String messageId = null;
        try {
            messageId = this.getIdForEvent(event);
        }
        catch (TransformerException e) {
            this.logger.warn("The message cannot be processed because the digest could not be generated. Either make the payload serializable or use an expression.");
            return null;
        }
        catch (Exception ex) {
            exceptionSeen = true;
        }
        Lock lock = this.lockFactory.createLock(this.idrId + "-" + messageId);
        lock.lock();
        try {
            if (!exceptionSeen) {
                counter = this.findCounter(messageId);
                boolean bl = tooMany = counter != null && counter.get() > this.maxRedeliveryCount;
            }
            if (tooMany || exceptionSeen) {
                block18: {
                    if (this.deadLetterQueue == null) break block18;
                    Event event2 = this.deadLetterQueue.process(event);
                    return event2;
                }
                try {
                    throw new MessageRedeliveredException(messageId, counter.get(), this.maxRedeliveryCount, event, CoreMessages.createStaticMessage((String)"Redelivery exhausted"), this);
                }
                catch (MessageRedeliveredException ex) {
                    throw ex;
                }
                catch (Exception ex2) {
                    this.logger.info("Exception thrown from failed message processing for message " + messageId, (Throwable)ex2);
                    Event ex2 = null;
                    return ex2;
                }
            }
            Event returnEvent = this.processNext(event);
            counter = this.findCounter(messageId);
            if (counter != null) {
                this.resetCounter(messageId);
            }
            Event event3 = returnEvent;
            return event3;
        }
        finally {
            lock.unlock();
        }
    }

    private void resetCounter(String messageId) throws ObjectStoreException {
        this.store.remove((Serializable)((Object)messageId));
        this.store.store((Serializable)((Object)messageId), new AtomicInteger());
    }

    public AtomicInteger findCounter(String messageId) throws ObjectStoreException {
        boolean counterExists = this.store.contains((Serializable)((Object)messageId));
        if (counterExists) {
            return this.store.retrieve((Serializable)((Object)messageId));
        }
        return null;
    }

    private AtomicInteger incrementCounter(String messageId) throws ObjectStoreException {
        AtomicInteger counter = this.findCounter(messageId);
        if (counter == null) {
            counter = new AtomicInteger();
        } else {
            this.store.remove((Serializable)((Object)messageId));
        }
        counter.incrementAndGet();
        this.store.store((Serializable)((Object)messageId), counter);
        return counter;
    }

    private String getIdForEvent(Event event) throws Exception {
        if (this.useSecureHash) {
            Object payload = event.getMessage().getPayload().getValue();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            if (payload instanceof InputStream) {
                event = Event.builder(event).message(InternalMessage.builder(event.getMessage()).payload(bytes).build()).build();
            }
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        return this.muleContext.getExpressionManager().parse(this.idExpression, event, this.flowConstruct);
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public void setObjectStore(ObjectStore<AtomicInteger> store) {
        this.store = new ProvidedObjectStoreWrapper<AtomicInteger>(store, this.internalObjectStoreFactory());
    }

    public void setMessageProcessor(Processor processor) {
        this.deadLetterQueue = processor;
    }
}

