/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.util.rx.Operators;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractRequestResponseMessageProcessor
extends AbstractInterceptingMessageProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event process(Event event) throws MuleException {
        MessagingException exception = null;
        Event response = null;
        try {
            Event event2 = response = this.processResponse(this.processNext(this.processRequest(event)), event);
            if (response == null) {
                this.processFinally(event, exception);
            } else {
                this.processFinally(response, exception);
            }
            return event2;
        }
        catch (MessagingException e) {
            try {
                exception = e;
                Event event3 = this.processCatch(event, e);
                if (response == null) {
                    this.processFinally(event, exception);
                } else {
                    this.processFinally(response, exception);
                }
                return event3;
            }
            catch (Throwable throwable) {
                if (response == null) {
                    this.processFinally(event, exception);
                } else {
                    this.processFinally(response, exception);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).concatMap(request -> {
            Mono stream = Mono.just((Object)request).transform(this.processRequest());
            if (this.next != null) {
                stream = stream.transform(s -> this.applyNext((Publisher<Event>)s));
            }
            return stream.transform(this.processResponse((Event)request)).doOnSuccess(result -> this.processFinally(result != null ? result : request, null)).otherwise(MessagingException.class, exception -> {
                try {
                    Mono mono = Mono.just((Object)this.processCatch(exception.getEvent(), (MessagingException)((Object)((Object)exception))));
                    return mono;
                }
                catch (MessagingException me) {
                    Mono mono = Mono.error((Throwable)((Object)me));
                    return mono;
                }
                finally {
                    this.processFinally(exception.getEvent(), (MessagingException)((Object)((Object)exception)));
                }
            });
        });
    }

    protected Event processRequest(Event request) throws MuleException {
        return request;
    }

    protected Function<Publisher<Event>, Publisher<Event>> processRequest() {
        return stream -> Flux.from((Publisher)stream).map(event -> {
            try {
                return this.processRequest((Event)event);
            }
            catch (MuleException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    protected Event processResponse(Event response, Event request) throws MuleException {
        return response;
    }

    protected Function<Publisher<Event>, Publisher<Event>> processResponse(Event request) {
        return stream -> Flux.from((Publisher)stream).handle(Operators.nullSafeMap(org.mule.runtime.core.util.rx.Exceptions.checkedFunction(response -> this.processResponse((Event)response, request))));
    }

    protected void processFinally(Event event, MessagingException exception) {
    }

    protected Event processCatch(Event event, MessagingException exception) throws MessagingException {
        throw exception;
    }
}

