/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.FilterUnacceptedException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public abstract class AbstractFilteringMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected boolean throwOnUnaccepted = false;
    protected boolean onUnacceptedFlowConstruct;
    protected Processor unacceptedMessageProcessor;

    @Override
    public Event process(Event event) throws MuleException {
        boolean accepted;
        Event.Builder builder = Event.builder(event);
        try {
            accepted = this.accept(event, builder);
        }
        catch (Exception ex) {
            throw this.filterFailureException(builder.build(), ex);
        }
        if (accepted) {
            return this.processNext(builder.build());
        }
        return this.handleUnaccepted(builder.build());
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).concatMap(event -> {
            Event.Builder builder = Event.builder(event);
            boolean accepted = this.accept((Event)event, builder);
            if (accepted) {
                return this.applyNext((Publisher<Event>)Flux.just((Object)builder.build()));
            }
            return this.handleUnaccepted().apply((Event)event);
        });
    }

    protected abstract boolean accept(Event var1, Event.Builder var2);

    protected Event handleUnaccepted(Event event) throws MuleException {
        if (this.unacceptedMessageProcessor != null) {
            return this.unacceptedMessageProcessor.process(event);
        }
        if (this.isThrowOnUnaccepted()) {
            throw this.filterUnacceptedException(event);
        }
        return null;
    }

    private Function<Event, Publisher<Event>> handleUnaccepted() {
        if (this.unacceptedMessageProcessor != null) {
            return event -> Flux.just((Object)event).transform((Function)this.unacceptedMessageProcessor);
        }
        if (this.isThrowOnUnaccepted()) {
            return event -> {
                throw Exceptions.propagate((Throwable)this.filterUnacceptedException((Event)event));
            };
        }
        return publisher -> Flux.empty();
    }

    protected MessagingException filterFailureException(Event event, Exception ex) {
        return new MessagingException(event, ex, (Processor)this);
    }

    protected MuleException filterUnacceptedException(Event event) {
        return new FilterUnacceptedException(CoreMessages.messageRejectedByFilter());
    }

    public Processor getUnacceptedMessageProcessor() {
        return this.unacceptedMessageProcessor;
    }

    public void setUnacceptedMessageProcessor(Processor unacceptedMessageProcessor) {
        this.unacceptedMessageProcessor = unacceptedMessageProcessor;
        if (unacceptedMessageProcessor instanceof FlowConstruct) {
            this.onUnacceptedFlowConstruct = true;
        }
    }

    public boolean isThrowOnUnaccepted() {
        return this.throwOnUnaccepted;
    }

    public void setThrowOnUnaccepted(boolean throwOnUnaccepted) {
        this.throwOnUnaccepted = throwOnUnaccepted;
    }
}

