/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyEventConverter;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;
import org.mule.runtime.core.policy.SourcePolicy;

public class DefaultSourcePolicy
implements SourcePolicy {
    private final Policy policy;
    private final Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();

    public DefaultSourcePolicy(Policy policy, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer, PolicyStateHandler policyStateHandler) {
        this.policy = policy;
        this.sourcePolicyParametersTransformer = sourcePolicyParametersTransformer;
        this.policyStateHandler = policyStateHandler;
    }

    @Override
    public Event process(Event sourceEvent, Processor nextOperation, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) throws Exception {
        Processor sourceNextOperation = this.buildFlowExecutionWithPolicyFunction(nextOperation, sourceEvent, messageSourceResponseParametersProcessor);
        this.policyStateHandler.updateNextOperation(sourceEvent.getContext().getId(), sourceNextOperation);
        Event result = this.policy.getPolicyChain().process(this.policyEventConverter.createEvent(sourceEvent.getMessage(), Event.builder(sourceEvent.getContext()).build()));
        return Event.builder(result.getContext()).message(result.getMessage()).build();
    }

    private Processor buildFlowExecutionWithPolicyFunction(Processor nextOperation, Event sourceEvent, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        return processEvent -> {
            PolicyStateId policyStateId = new PolicyStateId(sourceEvent.getContext().getId(), this.policy.getPolicyId());
            Event lastPolicyEvent = processEvent;
            try {
                this.policyStateHandler.updateState(policyStateId, lastPolicyEvent);
                Event flowExecutionResponse = nextOperation.process(sourceEvent);
                Message message = this.sourcePolicyParametersTransformer.map(policyTransformer -> {
                    Map<String, Object> responseParameters = messageSourceResponseParametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply(flowExecutionResponse);
                    return this.sourcePolicyParametersTransformer.get().fromSuccessResponseParametersToMessage(responseParameters);
                }).orElseGet(flowExecutionResponse::getMessage);
                return this.policyEventConverter.createEvent(message, this.policyStateHandler.getLatestState(policyStateId).orElse(lastPolicyEvent));
            }
            catch (MessagingException messagingException) {
                InternalMessage message = messagingException.getEvent().getMessage();
                Map<String, Object> failureParameters = messageSourceResponseParametersProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent());
                if (this.sourcePolicyParametersTransformer.isPresent()) {
                    message = this.sourcePolicyParametersTransformer.get().fromFailureResponseParametersToMessage(failureParameters);
                    throw new MessagingException(Event.builder(lastPolicyEvent).message(message).build(), messagingException.getCause());
                }
                throw messagingException;
            }
        };
    }
}

