/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.policy.CompositeOperationPolicy;
import org.mule.runtime.core.policy.CompositeSourcePolicy;
import org.mule.runtime.core.policy.DefaultOperationPolicyFactory;
import org.mule.runtime.core.policy.DefaultSourcePolicyFactory;
import org.mule.runtime.core.policy.NullPolicyProvider;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.OperationPolicyFactory;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.PolicyProvider;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SourcePolicyFactory;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyStateHandler policyStateHandler;
    private Collection<OperationPolicyParametersTransformer> operationPolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyParametersTransformer> sourcePolicyParametersTransformerCollection = Collections.emptyList();
    private PolicyProvider policyProvider;
    private OperationPolicyFactory operationPolicyFactory;
    private SourcePolicyFactory sourcePolicyFactory;

    @Override
    public Optional<SourcePolicy> findSourcePolicyInstance(String executionIdentifier, ComponentIdentifier sourceIdentifier) {
        List<Policy> parameterizedPolicies = this.policyProvider.findSourceParameterizedPolicies(sourceIdentifier);
        if (parameterizedPolicies.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CompositeSourcePolicy(parameterizedPolicies, this.lookupSourceParametersTransformer(sourceIdentifier), this.sourcePolicyFactory));
    }

    @Override
    public Optional<OperationPolicy> findOperationPolicy(String executionIdentifier, ComponentIdentifier operationIdentifier) {
        List<Policy> parameterizedPolicies = this.policyProvider.findOperationParameterizedPolicies(operationIdentifier);
        if (parameterizedPolicies.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CompositeOperationPolicy(parameterizedPolicies, this.lookupOperationParametersTransformer(operationIdentifier), this.operationPolicyFactory));
    }

    @Override
    public Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.operationPolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    @Override
    public Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.sourcePolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    public void initialise() throws InitialisationException {
        try {
            this.operationPolicyFactory = new DefaultOperationPolicyFactory(this.policyStateHandler);
            this.sourcePolicyFactory = new DefaultSourcePolicyFactory(this.policyStateHandler);
            this.policyProvider = this.muleContext.getRegistry().lookupObject(PolicyProvider.class);
            if (this.policyProvider == null) {
                this.policyProvider = new NullPolicyProvider();
            }
            this.sourcePolicyParametersTransformerCollection = this.muleContext.getRegistry().lookupObjects(SourcePolicyParametersTransformer.class);
            this.operationPolicyParametersTransformerCollection = this.muleContext.getRegistry().lookupObjects(OperationPolicyParametersTransformer.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
        }
    }

    @Override
    public void disposePoliciesResources(String executionIdentifier) {
        this.policyStateHandler.destroyState(executionIdentifier);
    }
}

