/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.OperationParametersProcessor;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyEventConverter;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;

public class DefaultOperationPolicy
implements OperationPolicy {
    private final Policy policy;
    private final Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();

    public DefaultOperationPolicy(Policy policy, Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer, PolicyStateHandler policyStateHandler) {
        this.policy = policy;
        this.operationPolicyParametersTransformer = operationPolicyParametersTransformer;
        this.policyStateHandler = policyStateHandler;
    }

    @Override
    public Event process(Event operationEvent, Processor nextProcessor, OperationParametersProcessor operationParametersProcessor) throws Exception {
        PolicyStateId policyStateId = new PolicyStateId(operationEvent.getContext().getId(), this.policy.getPolicyId());
        Optional<Event> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
        Event variablesProviderEvent = latestPolicyState.orElseGet(() -> Event.builder(operationEvent.getContext()).build());
        this.policyStateHandler.updateState(policyStateId, variablesProviderEvent);
        Map<String, Object> originalParametersMap = operationParametersProcessor.getOperationParameters();
        InternalMessage message = operationEvent.getMessage();
        message = this.operationPolicyParametersTransformer.map(parametersTransformer -> parametersTransformer.fromParametersToMessage(originalParametersMap)).orElse(message);
        Event policyEvent = this.policyEventConverter.createEvent(message, variablesProviderEvent);
        Processor operationCall = this.buildOperationExecutionWithPolicyFunction(nextProcessor);
        this.policyStateHandler.updateNextOperation(policyStateId.getExecutionIndentifier(), operationCall);
        Event policyChainResult = this.policy.getPolicyChain().process(policyEvent);
        this.policyStateHandler.updateState(policyStateId, policyChainResult);
        return this.policyEventConverter.createEvent(policyChainResult.getMessage(), operationEvent);
    }

    private Processor buildOperationExecutionWithPolicyFunction(Processor nextOperation) throws Exception {
        return policyExecuteNextEvent -> {
            try {
                PolicyStateId policyStateId = new PolicyStateId(policyExecuteNextEvent.getContext().getId(), this.policy.getPolicyId());
                this.policyStateHandler.updateState(policyStateId, policyExecuteNextEvent);
                Event operationResult = nextOperation.process(policyExecuteNextEvent);
                return this.policyEventConverter.createEvent(operationResult.getMessage(), policyExecuteNextEvent);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
    }
}

