/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.Policy;

public abstract class AbstractCompositePolicy<ParametersTransformer, ParametersProcessor> {
    private List<Policy> parameterizedPolicies;
    private Optional<ParametersTransformer> parametersTransformer;

    public AbstractCompositePolicy(List<Policy> policies, Optional<ParametersTransformer> parametersTransformer) {
        Preconditions.checkArgument((!policies.isEmpty() ? 1 : 0) != 0, (String)"policies list cannot be empty");
        this.parameterizedPolicies = policies;
        this.parametersTransformer = parametersTransformer;
    }

    public Event process(Event operationEvent, Processor nextProcessor, ParametersProcessor parametersProcessor) throws Exception {
        return new NextOperationCall(operationEvent, nextProcessor, parametersProcessor).process(operationEvent);
    }

    protected abstract Event processNextOperation(Processor var1, Event var2) throws MuleException;

    protected abstract Event processPolicy(Policy var1, Processor var2, Optional<ParametersTransformer> var3, ParametersProcessor var4, Event var5) throws Exception;

    public class NextOperationCall
    implements Processor {
        private final Event originalEvent;
        private final ParametersProcessor parametersProcessor;
        private int index = 0;
        private Processor nextProcessor;

        public NextOperationCall(Event originalEvent, Processor nextProcessor, ParametersProcessor parametersProcessor) {
            this.nextProcessor = nextProcessor;
            this.originalEvent = originalEvent;
            this.parametersProcessor = parametersProcessor;
        }

        @Override
        public Event process(Event event) throws MuleException {
            Preconditions.checkState((this.index <= AbstractCompositePolicy.this.parameterizedPolicies.size() ? 1 : 0) != 0, (String)"composite policy index is greater that the number of policies.");
            if (this.index == AbstractCompositePolicy.this.parameterizedPolicies.size()) {
                return AbstractCompositePolicy.this.processNextOperation(this.nextProcessor, event);
            }
            Policy policy = (Policy)AbstractCompositePolicy.this.parameterizedPolicies.get(this.index);
            ++this.index;
            try {
                return AbstractCompositePolicy.this.processPolicy(policy, this, AbstractCompositePolicy.this.parametersTransformer, this.parametersProcessor, this.originalEvent);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        }
    }
}

