/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.metadata.SimpleDataType;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.generics.GenericsUtils;

public class DefaultDataTypeBuilder
implements DataTypeBuilder,
DataTypeBuilder.DataTypeCollectionTypeBuilder {
    private static ConcurrentHashMap<String, ProxyIndicator> proxyClassCache = new ConcurrentHashMap();
    private static LoadingCache<DefaultDataTypeBuilder, DataType> dataTypeCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<DefaultDataTypeBuilder, DataType>(){

        public DataType load(DefaultDataTypeBuilder key) throws Exception {
            return key.doBuild();
        }
    });
    private Reference<Class<?>> typeRef = new WeakReference<Class<Object>>(Object.class);
    private DataTypeBuilder itemTypeBuilder;
    private MediaType mediaType = MediaType.ANY;
    private boolean built = false;
    private static final List<Class<?>> consumableClasses = new ArrayList();

    public DefaultDataTypeBuilder() {
    }

    public DefaultDataTypeBuilder(DataType dataType) {
        if (dataType instanceof CollectionDataType) {
            this.typeRef = new WeakReference<Class>(dataType.getType());
            this.itemTypeBuilder = DataType.builder((DataType)((CollectionDataType)dataType).getItemDataType());
        } else {
            this.typeRef = new WeakReference<Class>(dataType.getType());
        }
        this.mediaType = dataType.getMediaType();
    }

    public DataTypeParamsBuilder type(Class<?> type) {
        this.validateAlreadyBuilt();
        Preconditions.checkNotNull(type, (String)"'type' cannot be null.");
        this.typeRef = new WeakReference(this.handleProxy(type));
        return this;
    }

    protected Class<?> handleProxy(Class<?> type) {
        if (DefaultDataTypeBuilder.isProxyClass(type)) {
            return type.getInterfaces()[0];
        }
        return type;
    }

    protected static <T> boolean isProxyClass(Class<T> type) {
        String typeName = type.getName();
        ProxyIndicator indicator = proxyClassCache.get(typeName);
        if (indicator != null) {
            Class classInMap = indicator.getTargetClass();
            if (classInMap == type) {
                return indicator.isProxy();
            }
            if (classInMap != null) {
                return Proxy.isProxyClass(type);
            }
        }
        boolean isProxy = Proxy.isProxyClass(type);
        proxyClassCache.put(typeName, new ProxyIndicator(type, isProxy));
        return isProxy;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder streamType(Class<? extends Iterator> iteratorType) {
        this.validateAlreadyBuilt();
        Preconditions.checkNotNull(iteratorType, (String)"'iteratorType' cannot be null.");
        if (!Iterator.class.isAssignableFrom(iteratorType)) {
            throw new IllegalArgumentException("iteratorType " + iteratorType.getName() + " is not an Iterator type");
        }
        this.typeRef = new WeakReference(this.handleProxy(iteratorType));
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        return this.asCollectionTypeBuilder();
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder collectionType(Class<? extends Collection> collectionType) {
        Class<?> itemType;
        this.validateAlreadyBuilt();
        Preconditions.checkNotNull(collectionType, (String)"'collectionType' cannot be null.");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("collectionType " + collectionType.getName() + " is not a Collection type");
        }
        this.typeRef = new WeakReference(this.handleProxy(collectionType));
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        if ((itemType = GenericsUtils.getCollectionType(this.typeRef.get())) != null) {
            this.itemTypeBuilder.type(itemType);
        }
        return this.asCollectionTypeBuilder();
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder asCollectionTypeBuilder() {
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemType(Class<?> itemType) {
        this.validateAlreadyBuilt();
        Preconditions.checkNotNull(itemType, (String)"'itemTypeBuilder' cannot be null.");
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        this.itemTypeBuilder.type(this.handleProxy(itemType));
        return this;
    }

    public DataTypeBuilder mediaType(String mediaType) {
        Objects.requireNonNull(mediaType);
        this.validateAlreadyBuilt();
        this.mediaType = MediaType.parse((String)mediaType);
        return this;
    }

    public DataTypeBuilder mediaType(MediaType mediaType) {
        Objects.requireNonNull(mediaType);
        this.validateAlreadyBuilt();
        this.mediaType = mediaType;
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemMediaType(String itemMimeType) {
        this.validateAlreadyBuilt();
        this.itemTypeBuilder.mediaType(itemMimeType);
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemMediaType(MediaType itemMediaType) {
        this.validateAlreadyBuilt();
        this.itemTypeBuilder.mediaType(itemMediaType);
        return this;
    }

    public DataTypeBuilder charset(String charset) {
        this.validateAlreadyBuilt();
        this.mediaType = StringUtils.isNotEmpty((String)charset) ? this.mediaType.withCharset(Charset.forName(charset)) : this.mediaType.withCharset(null);
        return this;
    }

    public DataTypeBuilder charset(Charset charset) {
        this.validateAlreadyBuilt();
        this.mediaType = this.mediaType.withCharset(charset);
        return this;
    }

    public DataTypeParamsBuilder fromObject(Object value) {
        this.validateAlreadyBuilt();
        if (value == null) {
            return this.type(Object.class);
        }
        DataTypeBuilder builder = (DataTypeBuilder)this.type(value.getClass());
        return this.getObjectMimeType(value).map(mediaType -> builder.mediaType(mediaType)).orElse((DataTypeParamsBuilder)builder);
    }

    private Optional<String> getObjectMimeType(Object value) {
        if (value instanceof DataHandler) {
            return Optional.of(((DataHandler)value).getContentType());
        }
        if (value instanceof DataSource) {
            return Optional.of(((DataSource)value).getContentType());
        }
        return Optional.empty();
    }

    public DataType build() {
        if (this.built) {
            this.throwAlreadyBuilt();
        }
        this.built = true;
        return (DataType)dataTypeCache.getUnchecked((Object)this);
    }

    protected DataType doBuild() {
        Class<?> type = this.typeRef.get();
        if (Collection.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type)) {
            return new DefaultCollectionDataType(type, this.itemTypeBuilder != null ? this.itemTypeBuilder.build() : DataType.OBJECT, this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
        }
        return new SimpleDataType(type, this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
    }

    protected void validateAlreadyBuilt() {
        if (this.built) {
            this.throwAlreadyBuilt();
        }
    }

    protected void throwAlreadyBuilt() {
        throw new IllegalStateException("DataType was already built from this builder. Reusing builder instances is not allowed.");
    }

    public int hashCode() {
        return Objects.hash(this.typeRef.get(), this.itemTypeBuilder, this.mediaType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultDataTypeBuilder other = (DefaultDataTypeBuilder)obj;
        return Objects.equals(this.typeRef.get(), other.typeRef.get()) && Objects.equals(this.itemTypeBuilder, other.itemTypeBuilder) && Objects.equals(this.mediaType, other.mediaType);
    }

    private static void addToConsumableClasses(String className) {
        try {
            consumableClasses.add(ClassUtils.loadClass(className, Message.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isConsumable(Class<?> payloadClass) {
        if (consumableClasses.isEmpty()) {
            return false;
        }
        for (Class<?> c : consumableClasses) {
            if (!c.isAssignableFrom(payloadClass)) continue;
            return true;
        }
        return false;
    }

    static {
        DefaultDataTypeBuilder.addToConsumableClasses("javax.xml.stream.XMLStreamReader");
        DefaultDataTypeBuilder.addToConsumableClasses("javax.xml.transform.stream.StreamSource");
        consumableClasses.add(OutputHandler.class);
        consumableClasses.add(InputStream.class);
        consumableClasses.add(Reader.class);
        consumableClasses.add(Iterator.class);
    }

    private static final class ProxyIndicator {
        private final WeakReference<Class> targetClassRef;
        private final boolean isProxy;

        ProxyIndicator(Class targetClass, boolean proxy) {
            this.targetClassRef = new WeakReference<Class>(targetClass);
            this.isProxy = proxy;
        }

        public Class getTargetClass() {
            return (Class)this.targetClassRef.get();
        }

        public boolean isProxy() {
            return this.isProxy;
        }
    }
}

