/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.ErrorMessageAwareException;

public final class ErrorBuilder {
    private Throwable exception;
    private String description;
    private String detailedDescription;
    private ErrorType errorType;
    private Message errorMessage;

    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    public static ErrorBuilder builder(Throwable e) {
        return new ErrorBuilder(e);
    }

    private ErrorBuilder() {
    }

    private ErrorBuilder(Throwable e) {
        String exceptionDescription;
        Throwable exception = e;
        if (e instanceof ErrorMessageAwareException) {
            exception = ((ErrorMessageAwareException)((Object)e)).getRootCause();
            this.errorMessage = ((ErrorMessageAwareException)((Object)e)).getErrorMessage();
        }
        this.exception = exception;
        this.description = exceptionDescription = exception.getMessage() != null ? exception.getMessage() : "unknown description";
        this.detailedDescription = exceptionDescription;
        MuleException muleRoot = ExceptionHelper.getRootMuleException((Throwable)this.exception);
        if (muleRoot != null && muleRoot.getMessage() != null) {
            this.description = muleRoot.getMessage();
        }
    }

    public ErrorBuilder exception(Throwable exception) {
        this.exception = exception;
        return this;
    }

    public ErrorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ErrorBuilder detailedDescription(String detailedDescription) {
        this.detailedDescription = detailedDescription;
        return this;
    }

    public ErrorBuilder errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ErrorBuilder errorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Error build() {
        Preconditions.checkState((this.exception != null ? 1 : 0) != 0, (String)"error exception cannot be null");
        Preconditions.checkState((this.description != null ? 1 : 0) != 0, (String)"description exception cannot be null");
        Preconditions.checkState((this.detailedDescription != null ? 1 : 0) != 0, (String)"detailed description exception cannot be null");
        Preconditions.checkState((this.errorType != null ? 1 : 0) != 0, (String)"errorType exception cannot be null");
        return new ErrorImplementation(this.exception, this.description, this.detailedDescription, this.errorType, this.errorMessage);
    }

    private static final class ErrorImplementation
    implements Error {
        private Throwable exception;
        private String description;
        private String detailedDescription;
        private ErrorType errorType;
        private Message muleMessage;

        private ErrorImplementation(Throwable exception, String description, String detailedDescription, ErrorType errorType, Message errorMessage) {
            this.exception = exception;
            this.description = description;
            this.detailedDescription = detailedDescription;
            this.errorType = errorType;
            this.muleMessage = errorMessage;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDetailedDescription() {
            return this.detailedDescription;
        }

        public ErrorType getErrorType() {
            return this.errorType;
        }

        public Throwable getCause() {
            return this.exception;
        }

        public Message getErrorMessage() {
            return this.muleMessage;
        }
    }
}

