/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.connector.ReplyToHandler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.ProcessingDescriptor;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.connector.DefaultReplyToHandler;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.message.DefaultMessageBuilder;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.metadata.DefaultTypedValue;
import org.mule.runtime.core.processor.strategy.LegacyNonBlockingProcessingStrategyFactory;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.core.util.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventBuilder
implements Event.Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageBuilder.class);
    private EventContext context;
    private InternalMessage message;
    private Map<String, DefaultTypedValue<Object>> flowVariables = new HashMap<String, DefaultTypedValue<Object>>();
    private Error error;
    private MessageExchangePattern exchangePattern = MessageExchangePattern.REQUEST_RESPONSE;
    private FlowConstruct flow;
    private GroupCorrelation groupCorrelation = new GroupCorrelation(null, null);
    private String legacyCorrelationId;
    private FlowCallStack flowCallStack = new DefaultFlowCallStack();
    private ReplyToHandler replyToHandler;
    private Object replyToDestination;
    private Boolean synchronous;
    private MuleSession session = new DefaultMuleSession();
    private Event originalEvent;
    private boolean modified;
    private boolean notificationsEnabled = true;

    public DefaultEventBuilder(EventContext messageContext) {
        this.context = messageContext;
    }

    public DefaultEventBuilder(Event event) {
        this.originalEvent = event;
        this.context = event.getContext();
        this.message = event.getMessage();
        this.flow = event.getFlowConstruct();
        this.groupCorrelation = event.getGroupCorrelation();
        this.legacyCorrelationId = event.getLegacyCorrelationId();
        this.flowCallStack = event.getFlowCallStack().clone();
        this.exchangePattern = event.getExchangePattern();
        this.replyToHandler = event.getReplyToHandler();
        this.replyToDestination = event.getReplyToDestination();
        this.message = event.getMessage();
        if (event.isSynchronous()) {
            this.synchronous = event.isSynchronous();
        }
        this.session = event.getSession();
        this.error = event.getError().orElse(null);
        this.notificationsEnabled = event.isNotificationsEnabled();
        event.getVariableNames().forEach(key -> this.flowVariables.put((String)key, (DefaultTypedValue)event.getVariable((String)key)));
    }

    @Override
    public Event.Builder message(InternalMessage message) {
        this.message = message;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder variables(Map<String, Object> flowVariables) {
        this.flowVariables.clear();
        flowVariables.forEach((s, o) -> this.flowVariables.put((String)s, new DefaultTypedValue<Object>(o, DataType.fromObject((Object)o))));
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder addVariable(String key, Object value) {
        this.flowVariables.put(key, new DefaultTypedValue<Object>(value, DataType.fromObject((Object)value)));
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder addVariable(String key, Object value, DataType dataType) {
        this.flowVariables.put(key, new DefaultTypedValue<Object>(value, dataType));
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder removeVariable(String key) {
        this.flowVariables.remove(key);
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder correlationId(String correlationId) {
        this.legacyCorrelationId = correlationId;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder groupCorrelation(GroupCorrelation correlation) {
        this.groupCorrelation = correlation;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder error(Error error) {
        this.error = error;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder synchronous(boolean synchronous) {
        this.synchronous = synchronous;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder exchangePattern(MessageExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder flow(FlowConstruct flow) {
        this.flow = flow;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder replyToHandler(ReplyToHandler replyToHandler) {
        this.replyToHandler = replyToHandler;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder replyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder session(MuleSession session) {
        this.session = session;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder disableNotifications() {
        this.notificationsEnabled = false;
        this.modified = true;
        return this;
    }

    @Override
    public Event build() {
        if (this.originalEvent != null && !this.modified) {
            return this.originalEvent;
        }
        return new EventImplementation(this.context, this.message, this.flowVariables, this.exchangePattern, this.flow, this.session, this.synchronous == null ? this.resolveEventSynchronicity() : this.synchronous.booleanValue(), this.replyToDestination, this.replyToHandler, this.flowCallStack, this.groupCorrelation, this.error, this.legacyCorrelationId, this.notificationsEnabled);
    }

    protected boolean resolveEventSynchronicity() {
        return this.isFlowConstructSynchronous() || this.exchangePattern != null && this.exchangePattern.hasResponse() && !this.isFlowConstructNonBlockingProcessingStrategy();
    }

    private boolean isFlowConstructSynchronous() {
        return this.flow instanceof ProcessingDescriptor && ((ProcessingDescriptor)((Object)this.flow)).isSynchronous();
    }

    protected boolean isFlowConstructNonBlockingProcessingStrategy() {
        return this.flow instanceof Pipeline && ((Pipeline)this.flow).getProcessingStrategy() instanceof LegacyNonBlockingProcessingStrategyFactory.LegacyNonBlockingProcessingStrategy;
    }

    public static class EventImplementation
    implements Event,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 1L;
        private final EventContext context;
        private InternalMessage message;
        private final MuleSession session;
        private transient FlowConstruct flowConstruct;
        private final MessageExchangePattern exchangePattern;
        private final ReplyToHandler replyToHandler;
        private final boolean synchronous;
        private final Object replyToDestination;
        private final boolean notificationsEnabled;
        private final CopyOnWriteCaseInsensitiveMap<String, DefaultTypedValue> variables = new CopyOnWriteCaseInsensitiveMap();
        private FlowCallStack flowCallStack = new DefaultFlowCallStack();
        private final String legacyCorrelationId;
        private final Error error;
        private GroupCorrelation groupCorrelation;

        private EventImplementation(EventContext context, InternalMessage message, Map<String, DefaultTypedValue<Object>> variables, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, boolean synchronous, Object replyToDestination, ReplyToHandler replyToHandler, FlowCallStack flowCallStack, GroupCorrelation groupCorrelation, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.flowConstruct = flowConstruct;
            this.session = session;
            this.message = message;
            variables.forEach((s, value) -> this.variables.put((String)s, new DefaultTypedValue(value.getValue(), value.getDataType())));
            this.exchangePattern = exchangePattern;
            this.replyToHandler = replyToHandler;
            this.replyToDestination = replyToDestination;
            this.synchronous = synchronous;
            this.flowCallStack = flowCallStack;
            this.groupCorrelation = groupCorrelation;
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        @Override
        public EventContext getContext() {
            return this.context;
        }

        @Override
        public InternalMessage getMessage() {
            return this.message;
        }

        public Optional<Error> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public byte[] getMessageAsBytes(MuleContext muleContext) throws DefaultMuleException {
            try {
                return (byte[])this.transformMessage(DataType.BYTE_ARRAY, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getValue().getClass().getName()), (Throwable)e);
            }
        }

        @Override
        public <T> T transformMessage(Class<T> outputType, MuleContext muleContext) throws TransformerException {
            return (T)this.transformMessage(DataType.fromType(outputType), muleContext);
        }

        @Override
        public Object transformMessage(DataType outputType, MuleContext muleContext) throws TransformerException {
            if (outputType == null) {
                throw new TransformerException(CoreMessages.objectIsNull("outputType"));
            }
            InternalMessage transformedMessage = muleContext.getTransformationService().transform(this.message, outputType);
            if (this.message.getPayload().getDataType().isStreamType()) {
                this.setMessage(transformedMessage);
            }
            return transformedMessage.getPayload().getValue();
        }

        @Override
        public String transformMessageToString(MuleContext muleContext) throws TransformerException {
            DataType dataType = DataType.builder((DataType)this.getMessage().getPayload().getDataType()).type(String.class).build();
            return (String)this.transformMessage(dataType, muleContext);
        }

        @Override
        public String getMessageAsString(MuleContext muleContext) throws MuleException {
            return this.getMessageAsString(this.getMessage().getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(muleContext)), muleContext);
        }

        @Override
        public String getMessageAsString(Charset encoding, MuleContext muleContext) throws MuleException {
            try {
                InternalMessage transformedMessage = muleContext.getTransformationService().transform(this.message, DataType.builder().type(String.class).charset(encoding).build());
                if (this.message.getPayload().getDataType().isStreamType()) {
                    this.setMessage(transformedMessage);
                }
                return (String)transformedMessage.getPayload().getValue();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
            }
        }

        public String toString() {
            return "DefaultMuleEvent{context=" + this.context + ", message=" + this.message + ", variables=" + this.variables + ", error=" + this.error + '}';
        }

        @Override
        public MuleSession getSession() {
            return this.session;
        }

        @Override
        public FlowConstruct getFlowConstruct() {
            return this.flowConstruct;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.message instanceof InternalMessage) {
                this.setMessage(this.message);
            }
            if (this.replyToHandler instanceof DefaultReplyToHandler) {
                ((DefaultReplyToHandler)this.replyToHandler).initAfterDeserialisation(muleContext);
            }
            if (this.replyToDestination instanceof DeserializationPostInitialisable) {
                try {
                    DeserializationPostInitialisable.Implementation.init(this.replyToDestination, muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(e);
                }
            }
            if (this.context.getOriginatingFlowName() != null) {
                this.flowConstruct = muleContext.getRegistry().lookupFlowConstruct(this.context.getOriginatingFlowName());
            }
        }

        @Override
        public MuleContext getMuleContext() {
            return this.flowConstruct.getMuleContext();
        }

        @Override
        public MessageExchangePattern getExchangePattern() {
            return this.exchangePattern;
        }

        @Override
        public ReplyToHandler getReplyToHandler() {
            return this.replyToHandler;
        }

        @Override
        public Object getReplyToDestination() {
            return this.replyToDestination;
        }

        @Override
        public boolean isSynchronous() {
            return this.synchronous;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (Map.Entry<String, DefaultTypedValue> entry : this.variables.entrySet()) {
                DefaultTypedValue value = entry.getValue();
                if (value == null || value instanceof Serializable) continue;
                String message = String.format("Unable to serialize the flow variable %s, which is of type %s ", entry.getKey(), value);
                logger.error(message);
                throw new IOException(message);
            }
        }

        private void setMessage(InternalMessage message) {
            this.message = message;
        }

        public Set<String> getVariableNames() {
            return this.variables.keySet();
        }

        public <T> TypedValue<T> getVariable(String key) {
            DefaultTypedValue typedValue = this.variables.get(key);
            if (typedValue == null) {
                throw new NoSuchElementException("The flow variable '" + key + "' does not exist.");
            }
            return typedValue;
        }

        @Override
        public boolean isNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.session.getSecurityContext();
        }

        @Override
        public GroupCorrelation getGroupCorrelation() {
            return this.groupCorrelation;
        }

        @Override
        public String getCorrelationId() {
            return this.legacyCorrelationId != null ? this.legacyCorrelationId : this.getContext().getCorrelationId();
        }

        @Override
        @Deprecated
        public String getLegacyCorrelationId() {
            return this.legacyCorrelationId;
        }
    }
}

