/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.management.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.management.stats.Statistics;

public abstract class AbstractFlowConstructStatistics
implements Statistics {
    private static final long serialVersionUID = 5337576392583767442L;
    protected final String flowConstructType;
    protected String name;
    protected boolean enabled = false;
    private long samplePeriod = 0L;
    protected final AtomicLong receivedEventSync = new AtomicLong(0L);
    protected final AtomicLong receivedEventASync = new AtomicLong(0L);

    public AbstractFlowConstructStatistics(String flowConstructType, String name) {
        this.name = name;
        this.flowConstructType = flowConstructType;
    }

    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized void clear() {
        this.receivedEventSync.set(0L);
        this.receivedEventASync.set(0L);
        this.samplePeriod = System.currentTimeMillis();
    }

    public void incReceivedEventSync() {
        this.receivedEventSync.addAndGet(1L);
    }

    public void incReceivedEventASync() {
        this.receivedEventASync.addAndGet(1L);
    }

    public long getAsyncEventsReceived() {
        return this.receivedEventASync.get();
    }

    public long getSyncEventsReceived() {
        return this.receivedEventSync.get();
    }

    public long getTotalEventsReceived() {
        return this.getSyncEventsReceived() + this.getAsyncEventsReceived();
    }

    public String getFlowConstructType() {
        return this.flowConstructType;
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }
}

