/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.lifecycle.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.lifecycle.processor.ProcessIfStartedWaitIfPausedMessageProcessor;

public class ProcessIfStartedWaitIfSyncPausedMessageProcessor
extends ProcessIfStartedWaitIfPausedMessageProcessor {
    public ProcessIfStartedWaitIfSyncPausedMessageProcessor(Startable startable, LifecycleState lifecycleState) {
        super(startable, lifecycleState);
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event.Builder builder = Event.builder(event);
        if (this.accept(event, builder)) {
            if (this.isPaused() && event.getExchangePattern().hasResponse()) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.startable.getClass().getName() + " " + this.getStartableName(this.startable) + " is paused. Blocking call until resumed");
                    }
                    while (this.isPaused()) {
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException e) {
                    throw new MessagingException(CoreMessages.interruptedWaitingForPaused(this.getStartableName(this.startable)), event, e, this);
                }
            }
            return this.processNext(builder.build());
        }
        return this.handleUnaccepted(builder.build());
    }
}

